/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class LocatedBlockHelper {
    private static final Method GET_LOCATED_BLOCK_LOCATIONS_METHOD;

    private LocatedBlockHelper() {
    }

    public static DatanodeInfo[] getLocatedBlockLocations(LocatedBlock block) {
        try {
            return (DatanodeInfo[])GET_LOCATED_BLOCK_LOCATIONS_METHOD.invoke((Object)block, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            GET_LOCATED_BLOCK_LOCATIONS_METHOD = LocatedBlock.class.getMethod("getLocations", new Class[0]);
        }
        catch (Exception e) {
            throw new Error("Can not initialize access to HDFS LocatedBlock.getLocations method", e);
        }
    }
}

