/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.JVM;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.ServerChannel;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NettyEventLoopGroupConfig {
    public static final String NETTY_WORKER_COUNT_KEY = "hbase.netty.worker.count";
    public static final int DEFAULT_NETTY_WORKER_COUNT = 0;
    public static final String NETTY_NATIVETRANSPORT_KEY = "hbase.netty.nativetransport";
    public static final boolean DEFAULT_NETTY_NATIVETRANSPORT = true;
    private final EventLoopGroup group;
    private final Class<? extends ServerChannel> serverChannelClass;
    private final Class<? extends Channel> clientChannelClass;

    private static boolean useEpoll(Configuration conf) {
        boolean epollEnabled = conf.getBoolean(NETTY_NATIVETRANSPORT_KEY, true);
        return epollEnabled && JVM.isLinux() && (JVM.isAmd64() || JVM.isAarch64());
    }

    public NettyEventLoopGroupConfig(Configuration conf, String threadPoolName) {
        boolean useEpoll = NettyEventLoopGroupConfig.useEpoll(conf);
        int workerCount = conf.getInt(NETTY_WORKER_COUNT_KEY, conf.getInt("hbase.netty.eventloop.rpcserver.thread.count", 0));
        DefaultThreadFactory eventLoopThreadFactory = new DefaultThreadFactory(threadPoolName, true, 10);
        if (useEpoll) {
            this.group = new EpollEventLoopGroup(workerCount, eventLoopThreadFactory);
            this.serverChannelClass = EpollServerSocketChannel.class;
            this.clientChannelClass = EpollSocketChannel.class;
        } else {
            this.group = new NioEventLoopGroup(workerCount, eventLoopThreadFactory);
            this.serverChannelClass = NioServerSocketChannel.class;
            this.clientChannelClass = NioSocketChannel.class;
        }
    }

    public EventLoopGroup group() {
        return this.group;
    }

    public Class<? extends ServerChannel> serverChannelClass() {
        return this.serverChannelClass;
    }

    public Class<? extends Channel> clientChannelClass() {
        return this.clientChannelClass;
    }
}

