/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class TraceUtil {
    private TraceUtil() {
    }

    public static Tracer getGlobalTracer() {
        return GlobalOpenTelemetry.getTracer((String)"org.apache.hbase", (String)VersionInfo.getVersion());
    }

    public static Span createSpan(String name) {
        return TraceUtil.createSpan(name, SpanKind.INTERNAL);
    }

    private static Span createSpan(String name, SpanKind kind) {
        return TraceUtil.getGlobalTracer().spanBuilder(name).setSpanKind(kind).startSpan();
    }

    public static Span createRemoteSpan(String name, Context ctx) {
        return TraceUtil.getGlobalTracer().spanBuilder(name).setParent(ctx).setSpanKind(SpanKind.SERVER).startSpan();
    }

    public static Span createClientSpan(String name) {
        return TraceUtil.createSpan(name, SpanKind.CLIENT);
    }

    public static <T> CompletableFuture<T> tracedFuture(Supplier<CompletableFuture<T>> action, Supplier<Span> spanSupplier) {
        Span span = spanSupplier.get();
        try (Scope ignored = span.makeCurrent();){
            CompletableFuture<T> future = action.get();
            TraceUtil.endSpan(future, span);
            CompletableFuture<T> completableFuture = future;
            return completableFuture;
        }
    }

    public static <T> CompletableFuture<T> tracedFuture(Supplier<CompletableFuture<T>> action, String spanName) {
        Span span = TraceUtil.createSpan(spanName);
        try (Scope ignored = span.makeCurrent();){
            CompletableFuture<T> future = action.get();
            TraceUtil.endSpan(future, span);
            CompletableFuture<T> completableFuture = future;
            return completableFuture;
        }
    }

    public static <T> List<CompletableFuture<T>> tracedFutures(Supplier<List<CompletableFuture<T>>> action, Supplier<Span> spanSupplier) {
        Span span = spanSupplier.get();
        try (Scope ignored = span.makeCurrent();){
            List<CompletableFuture<CompletableFuture>> futures = action.get();
            TraceUtil.endSpan(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])), span);
            List<CompletableFuture<CompletableFuture>> list = futures;
            return list;
        }
    }

    public static void setError(Span span, Throwable error) {
        span.recordException(error);
        span.setStatus(StatusCode.ERROR);
    }

    private static void endSpan(CompletableFuture<?> future, Span span) {
        FutureUtils.addListener(future, (resp, error) -> {
            if (error != null) {
                TraceUtil.setError(span, error);
            } else {
                span.setStatus(StatusCode.OK);
            }
            span.end();
        });
    }

    public static Runnable tracedRunnable(Runnable runnable, String spanName) {
        return TraceUtil.tracedRunnable(runnable, () -> TraceUtil.createSpan(spanName));
    }

    public static Runnable tracedRunnable(Runnable runnable, Supplier<Span> spanSupplier) {
        return () -> {
            Span span = (Span)spanSupplier.get();
            try (Scope ignored = span.makeCurrent();){
                runnable.run();
                span.setStatus(StatusCode.OK);
            }
            finally {
                span.end();
            }
        };
    }

    public static <T extends Throwable> void trace(ThrowingRunnable<T> runnable, String spanName) throws T {
        TraceUtil.trace(runnable, () -> TraceUtil.createSpan(spanName));
    }

    public static <T extends Throwable> void trace(ThrowingRunnable<T> runnable, Supplier<Span> spanSupplier) throws T {
        Span span = spanSupplier.get();
        try (Scope ignored = span.makeCurrent();){
            runnable.run();
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable e) {
            TraceUtil.setError(span, e);
            throw e;
        }
        finally {
            span.end();
        }
    }

    public static <R, T extends Throwable> R trace(ThrowingCallable<R, T> callable, String spanName) throws T {
        return TraceUtil.trace(callable, () -> TraceUtil.createSpan(spanName));
    }

    /*
     * Exception decompiling
     */
    public static <R, T extends Throwable> R trace(ThrowingCallable<R, T> callable, Supplier<Span> spanSupplier) throws T {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    public static interface ThrowingCallable<R, T extends Throwable> {
        public R call() throws T;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

