/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.cleaner.BaseTimeToLiveFileCleaner;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class TimeToLiveLogCleaner
extends BaseTimeToLiveFileCleaner {
    public static final String TTL_CONF_KEY = "hbase.master.logcleaner.ttl";
    public static final long DEFAULT_TTL = 600000L;

    @Override
    protected long getTtlMs(Configuration conf) {
        return conf.getLong(TTL_CONF_KEY, 600000L);
    }

    @Override
    protected boolean valiateFilename(Path file) {
        return AbstractFSWALProvider.validateWALFilename(file.getName());
    }
}

