/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ReflectedFunctionCache<I, R> {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectedFunctionCache.class);
    private final ConcurrentMap<String, Function<I, ? extends R>> lambdasByClass = new ConcurrentHashMap<String, Function<I, ? extends R>>();
    private final Class<R> baseClass;
    private final Class<I> argClass;
    private final String methodName;
    private final ClassLoader classLoader = this.getClass().getClassLoader();

    public ReflectedFunctionCache(Class<R> baseClass, Class<I> argClass, String staticMethodName) {
        this.baseClass = baseClass;
        this.argClass = argClass;
        this.methodName = staticMethodName;
    }

    @Nullable
    public R getAndCallByName(String className, I argument) {
        Function lambda = ConcurrentMapUtils.computeIfAbsent(this.lambdasByClass, className, () -> this.loadFunction(className));
        return lambda.apply(argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function<I, ? extends R> loadFunction(String className) {
        long startTime = System.nanoTime();
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            if (!this.baseClass.isAssignableFrom(clazz)) {
                LOG.debug("Requested class {} is not assignable to {}, skipping creation of function", (Object)className, (Object)this.baseClass.getName());
                Function<Object, Object> function = this::notFound;
                return function;
            }
            Function<I, ?> function = ReflectionUtils.getOneArgStaticMethodAsFunction(clazz, this.methodName, this.argClass, clazz);
            return function;
        }
        catch (Throwable t) {
            LOG.debug("Failed to create function for {}", (Object)className, (Object)t);
            Function<Object, Object> function = this::notFound;
            return function;
        }
        finally {
            LOG.debug("Populated cache for {} in {}ms", (Object)className, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        }
    }

    private R notFound(I argument) {
        return null;
    }
}

