/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ClientUtils {
    private ClientUtils() {
    }

    public static LoginContext getLoginContext() throws LoginException {
        return new LoginContext("", new Subject(), null, new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("useKeyTab", "false");
                options.put("storeKey", "false");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("refreshKrb5Config", "true");
                options.put("isInitiator", "true");
                String ticketCache = System.getenv("KRB5CCNAME");
                if (ticketCache != null) {
                    options.put("ticketCache", ticketCache);
                }
                options.put("debug", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        });
    }

    public static void printRow(TRowResult rowResult) {
        TreeMap sorted = new TreeMap();
        for (Map.Entry column : rowResult.columns.entrySet()) {
            sorted.put(ClientUtils.utf8(((ByteBuffer)column.getKey()).array()), column.getValue());
        }
        StringBuilder rowStr = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            rowStr.append((String)entry.getKey());
            rowStr.append(" => ");
            rowStr.append(ClientUtils.utf8(((TCell)entry.getValue()).value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + ClientUtils.utf8(rowResult.row.array()) + ", cols: " + rowStr);
    }

    public static String utf8(byte[] buf) {
        try {
            return Bytes.toString((byte[])buf);
        }
        catch (IllegalArgumentException e) {
            return "[INVALID UTF-8]";
        }
    }
}

