/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.TestVerifyReplication;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestVerifyReplicationAdjunct
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplicationAdjunct.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVerifyReplicationAdjunct.class);
    private static final String PEER_ID = "2";
    private static final TableName peerTableName = TableName.valueOf((String)"peerTest");
    private static Table htable3;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
        UTIL2.deleteTableData(peerTableName);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        TableDescriptor peerTable = TableDescriptorBuilder.newBuilder((TableName)peerTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])noRepfamName).setMaxVersions(100).build()).build();
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(peerTable, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        htable3 = connection2.getTable(peerTableName);
    }

    @Test
    public void testHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1002"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v1001"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v1112"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        put.addColumn(famName, qualifierName, ts + 4L, Bytes.toBytes((String)"v1111"));
        htable2.put(put);
        put.addColumn(famName, qualifierName, ts + 5L, Bytes.toBytes((String)"v1112"));
        htable2.put(put);
        scan = new Scan();
        scan.readVersions(100);
        scanner1 = htable2.getScanner(scan);
        res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)5L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
        TestVerifyReplication.runVerifyReplication(args, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVersionMismatchHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v2"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v3"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        try {
            hbaseAdmin.disableReplicationPeer(PEER_ID);
            Put put2 = new Put(Bytes.toBytes((String)"r1"));
            put2.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v99"));
            htable2.put(put2);
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(100);
            scanner1.close();
            Assert.assertEquals((long)1L, (long)res1.length);
            Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
            String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
            TestVerifyReplication.runVerifyReplication(args, 0, 1);
        }
        finally {
            hbaseAdmin.enableReplicationPeer(PEER_ID);
        }
    }

    @Test
    public void testVerifyReplicationPrefixFiltering() throws Exception {
        byte[] prefixRow = Bytes.toBytes((String)"prefixrow");
        byte[] prefixRow2 = Bytes.toBytes((String)"secondrow");
        TestVerifyReplicationAdjunct.loadData((String)"prefixrow", (byte[])prefixRow);
        TestVerifyReplicationAdjunct.loadData((String)"secondrow", (byte[])prefixRow2);
        TestVerifyReplicationAdjunct.loadData((String)"aaa", (byte[])row);
        TestVerifyReplicationAdjunct.loadData((String)"zzz", (byte[])row);
        TestVerifyReplicationAdjunct.waitForReplication((int)400, (int)200);
        String[] args = new String[]{"--row-prefixes=prefixrow,secondrow", PEER_ID, tableName.getNameAsString()};
        TestVerifyReplication.runVerifyReplication(args, 200, 0);
    }

    @Test
    public void testVerifyReplicationSnapshotArguments() {
        Object[] args = new String[]{"--sourceSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotTmpDir=/tmp/", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=/tmp/", "--peerSnapshotName=snapshot2", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
    }

    @Test
    public void testVerifyReplicationWithSnapshotSupport() throws Exception {
        TestVerifyReplicationAdjunct.runSmallBatchTest();
        Path rootDir = CommonFSUtils.getRootDir((Configuration)CONF1);
        FileSystem fs = rootDir.getFileSystem(CONF1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = CommonFSUtils.getRootDir((Configuration)CONF2);
        FileSystem peerFs = peerRootDir.getFileSystem(CONF2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String temPath1 = UTIL1.getRandomDir().toString();
        String temPath2 = "/tmp" + System.currentTimeMillis();
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + CommonFSUtils.getRootDir((Configuration)CONF2), PEER_ID, tableName.getNameAsString()};
        TestVerifyReplication.runVerifyReplication(args, 100, 0);
        TestVerifyReplication.checkRestoreTmpDir(CONF1, temPath1, 1);
        TestVerifyReplication.checkRestoreTmpDir(CONF2, temPath2, 1);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + CommonFSUtils.getRootDir((Configuration)CONF2), PEER_ID, tableName.getNameAsString()};
        TestVerifyReplication.runVerifyReplication(args, 0, 100);
        TestVerifyReplication.checkRestoreTmpDir(CONF1, temPath1, 2);
        TestVerifyReplication.checkRestoreTmpDir(CONF2, temPath2, 2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        htable3.close();
        TestReplicationBase.tearDownAfterClass();
    }
}

