/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.net;

import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.net.HostAndPort;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Address
implements Comparable<Address> {
    private final HostAndPort hostAndPort;

    private Address(HostAndPort hostAndPort) {
        this.hostAndPort = hostAndPort;
    }

    public static Address fromParts(String hostname, int port) {
        return new Address(HostAndPort.fromParts((String)hostname, (int)port));
    }

    public static Address fromString(String hostnameAndPort) {
        return new Address(HostAndPort.fromString((String)hostnameAndPort));
    }

    public static Address fromSocketAddress(InetSocketAddress addr) {
        return Address.fromParts(addr.getHostString(), addr.getPort());
    }

    public static InetSocketAddress toSocketAddress(Address addr) {
        return new InetSocketAddress(addr.getHostName(), addr.getPort());
    }

    public static InetSocketAddress[] toSocketAddress(Address[] addrs) {
        if (addrs == null) {
            return null;
        }
        InetSocketAddress[] result = new InetSocketAddress[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            result[i] = Address.toSocketAddress(addrs[i]);
        }
        return result;
    }

    public String getHostName() {
        return this.hostAndPort.getHost();
    }

    @Deprecated
    public String getHostname() {
        return this.hostAndPort.getHost();
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public String toString() {
        return this.hostAndPort.toString();
    }

    public String toStringWithoutDomain() {
        String hostname = this.getHostName();
        String[] parts = hostname.split("\\.");
        if (parts.length > 1) {
            for (String part : parts) {
                if (StringUtils.isNumeric((CharSequence)part)) continue;
                return Address.fromParts(parts[0], this.getPort()).toString();
            }
        }
        return this.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Address) {
            Address that = (Address)other;
            return this.getHostName().equals(that.getHostName()) && this.getPort() == that.getPort();
        }
        return false;
    }

    public int hashCode() {
        return this.getHostName().hashCode() ^ this.getPort();
    }

    @Override
    public int compareTo(Address that) {
        int compare = this.getHostName().compareTo(that.getHostName());
        if (compare != 0) {
            return compare;
        }
        return this.getPort() - that.getPort();
    }
}

