/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestIOFencing {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIOFencing.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestIOFencing.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"tabletest");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final int FIRST_BATCH_COUNT = 4000;
    private static final int SECOND_BATCH_COUNT = 4000;

    @Test
    public void testFencingAroundCompaction() throws Exception {
        for (MemoryCompactionPolicy policy : MemoryCompactionPolicy.values()) {
            this.doTest(BlockCompactionsInPrepRegion.class, policy);
        }
    }

    @Test
    public void testFencingAroundCompactionAfterWALSync() throws Exception {
        for (MemoryCompactionPolicy policy : MemoryCompactionPolicy.values()) {
            this.doTest(BlockCompactionsInCompletionRegion.class, policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(Class<?> regionClass, MemoryCompactionPolicy policy) throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setClass("hbase.hregion.impl", regionClass, HRegion.class);
        c.setLong("hbase.hregion.memstore.flush.size", 25000L);
        c.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        c.setInt("hbase.hstore.compaction.min", 1);
        c.setInt("hbase.hstore.compactionThreshold", 1000);
        c.setLong("hbase.hstore.blockingStoreFiles", 1000L);
        c.setInt("hbase.regionserver.thread.splitcompactcheckfrequency", 1000);
        c.set("hbase.hregion.compacting.memstore.type", String.valueOf(policy));
        LOG.info("Starting mini cluster");
        TEST_UTIL.startMiniCluster(1);
        CompactionBlockerRegion compactingRegion = null;
        Admin admin = null;
        try {
            int count;
            LOG.info("Creating admin");
            admin = TEST_UTIL.getConnection().getAdmin();
            LOG.info("Creating table");
            TEST_UTIL.createTable(TABLE_NAME, FAMILY);
            Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);
            LOG.info("Loading test table");
            List<HRegion> testRegions = TEST_UTIL.getMiniHBaseCluster().findRegionsForTable(TABLE_NAME);
            Assert.assertEquals((long)1L, (long)testRegions.size());
            compactingRegion = (CompactionBlockerRegion)testRegions.get(0);
            LOG.info("Blocking compactions");
            compactingRegion.stopCompactions();
            long lastFlushTime = compactingRegion.getEarliestFlushTimeForAllStores();
            TEST_UTIL.loadNumericRows(table, FAMILY, 0, 4000);
            HRegionInfo oldHri = new HRegionInfo(table.getName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            WALProtos.CompactionDescriptor compactionDescriptor = ProtobufUtil.toCompactionDescriptor((RegionInfo)oldHri, (byte[])FAMILY, (List)Lists.newArrayList((Object[])new Path[]{new Path("/a")}), (List)Lists.newArrayList((Object[])new Path[]{new Path("/b")}), (Path)new Path("store_dir"));
            WALUtil.writeCompactionMarker((WAL)compactingRegion.getWAL(), (NavigableMap)compactingRegion.getReplicationScope(), (RegionInfo)oldHri, (WALProtos.CompactionDescriptor)compactionDescriptor, (MultiVersionConcurrencyControl)compactingRegion.getMVCC());
            long startWaitTime = System.currentTimeMillis();
            while (compactingRegion.getEarliestFlushTimeForAllStores() <= lastFlushTime || compactingRegion.countStoreFiles() <= 1) {
                LOG.info("Waiting for the region to flush " + compactingRegion.getRegionInfo().getRegionNameAsString());
                Thread.sleep(1000L);
                admin.flush(table.getName());
                Assert.assertTrue((String)"Timed out waiting for the region to flush", (System.currentTimeMillis() - startWaitTime < 30000L ? 1 : 0) != 0);
            }
            Assert.assertTrue((compactingRegion.countStoreFiles() > 1 ? 1 : 0) != 0);
            final byte[] REGION_NAME = compactingRegion.getRegionInfo().getRegionName();
            LOG.info("Asking for compaction");
            admin.majorCompact(TABLE_NAME);
            LOG.info("Waiting for compaction to be about to start");
            compactingRegion.waitForCompactionToBlock();
            LOG.info("Starting a new server");
            JVMClusterUtil.RegionServerThread newServerThread = TEST_UTIL.getMiniHBaseCluster().startRegionServer();
            final HRegionServer newServer = newServerThread.getRegionServer();
            LOG.info("Killing region server ZK lease");
            TEST_UTIL.expireRegionServerSession(0);
            CompactionBlockerRegion newRegion = null;
            startWaitTime = System.currentTimeMillis();
            LOG.info("Waiting for the new server to pick up the region " + Bytes.toString((byte[])REGION_NAME));
            Waiter.waitFor((Configuration)c, (long)60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    HRegion newRegion = newServer.getOnlineRegion(REGION_NAME);
                    return newRegion != null;
                }
            });
            newRegion = (CompactionBlockerRegion)newServer.getOnlineRegion(REGION_NAME);
            FileSystem fs = newRegion.getFilesystem();
            for (String f : newRegion.getStoreFileList(new byte[][]{FAMILY})) {
                Assert.assertTrue((String)("After compaction, does not exist: " + f), (boolean)fs.exists(new Path(f)));
            }
            LOG.info("Allowing compaction to proceed");
            compactingRegion.allowCompactions();
            while (compactingRegion.compactCount.get() == 0) {
                Thread.sleep(1000L);
            }
            LOG.info("Compaction finished");
            TEST_UTIL.loadNumericRows(table, FAMILY, 4000, 8000);
            admin.majorCompact(TABLE_NAME);
            startWaitTime = System.currentTimeMillis();
            while (newRegion.compactCount.get() == 0) {
                Thread.sleep(1000L);
                Assert.assertTrue((String)"New region never compacted", (System.currentTimeMillis() - startWaitTime < 180000L ? 1 : 0) != 0);
            }
            int i = 0;
            while (true) {
                try {
                    count = TEST_UTIL.countRows(table);
                }
                catch (DoNotRetryIOException e) {
                    if (i >= 30 || !e.getMessage().contains("File does not exist")) {
                        throw e;
                    }
                    Thread.sleep(1000L);
                    ++i;
                    continue;
                }
                break;
            }
            if (policy == MemoryCompactionPolicy.EAGER || policy == MemoryCompactionPolicy.ADAPTIVE) {
                Assert.assertTrue((8000 >= count ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)8000L, (long)count);
            }
        }
        finally {
            if (compactingRegion != null) {
                compactingRegion.allowCompactions();
            }
            admin.close();
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class BlockCompactionsInCompletionHStore
    extends HStore {
        CompactionBlockerRegion r;

        protected BlockCompactionsInCompletionHStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam, boolean warmup) throws IOException {
            super(region, family, confParam, warmup);
            this.r = (CompactionBlockerRegion)region;
        }

        protected void completeCompaction(Collection<HStoreFile> compactedFiles) throws IOException {
            try {
                this.r.compactionsWaiting.countDown();
                this.r.compactionsBlocked.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            super.completeCompaction(compactedFiles);
        }
    }

    public static class BlockCompactionsInCompletionRegion
    extends CompactionBlockerRegion {
        public BlockCompactionsInCompletionRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, RegionInfo info, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        protected HStore instantiateHStore(ColumnFamilyDescriptor family, boolean warmup) throws IOException {
            return new BlockCompactionsInCompletionHStore(this, family, this.conf, warmup);
        }
    }

    public static class BlockCompactionsInPrepRegion
    extends CompactionBlockerRegion {
        public BlockCompactionsInPrepRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, RegionInfo info, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        protected void doRegionCompactionPrep() throws IOException {
            this.compactionsWaiting.countDown();
            try {
                this.compactionsBlocked.await();
            }
            catch (InterruptedException ex) {
                throw new IOException();
            }
            super.doRegionCompactionPrep();
        }
    }

    public static abstract class CompactionBlockerRegion
    extends HRegion {
        AtomicInteger compactCount = new AtomicInteger();
        volatile CountDownLatch compactionsBlocked = new CountDownLatch(0);
        volatile CountDownLatch compactionsWaiting = new CountDownLatch(0);

        public CompactionBlockerRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, RegionInfo info, TableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        public void stopCompactions() {
            this.compactionsBlocked = new CountDownLatch(1);
            this.compactionsWaiting = new CountDownLatch(1);
        }

        public void allowCompactions() {
            LOG.debug("allowing compactions");
            this.compactionsBlocked.countDown();
        }

        public void waitForCompactionToBlock() throws IOException {
            try {
                LOG.debug("waiting for compaction to block");
                this.compactionsWaiting.await();
                LOG.debug("compaction block reached");
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController) throws IOException {
            try {
                boolean bl = super.compact(compaction, store, throughputController);
                return bl;
            }
            finally {
                this.compactCount.getAndIncrement();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean compact(CompactionContext compaction, HStore store, ThroughputController throughputController, User user) throws IOException {
            try {
                boolean bl = super.compact(compaction, store, throughputController, user);
                return bl;
            }
            finally {
                this.compactCount.getAndIncrement();
            }
        }

        public int countStoreFiles() {
            int count = 0;
            for (HStore store : this.stores.values()) {
                count += store.getStorefilesCount();
            }
            return count;
        }
    }
}

