/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.cdc.runtime.operators.transform.converter;

import org.apache.flink.cdc.common.event.DataChangeEvent;

import java.util.Optional;

import static org.apache.flink.cdc.common.event.OperationType.DELETE;

/** This {@link PostTransformConverter} convert delete events to insert events. */
public class SoftDeleteConverter implements PostTransformConverter {

    @Override
    public Optional<DataChangeEvent> convert(DataChangeEvent dataChangeEvent) {
        if (DELETE.equals(dataChangeEvent.op())) {
            return Optional.of(
                    DataChangeEvent.insertEvent(
                            dataChangeEvent.tableId(),
                            dataChangeEvent.before(),
                            dataChangeEvent.meta()));
        }
        return Optional.of(dataChangeEvent);
    }
}
