/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;

@Internal
public class AlterTableSchemaOperation
extends AlterTableOperation {
    private final CatalogTable catalogTable;

    public AlterTableSchemaOperation(ObjectIdentifier tableIdentifier, CatalogTable catalogTable, boolean ignoreIfNotExists) {
        super(tableIdentifier, ignoreIfNotExists);
        this.catalogTable = catalogTable;
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER TABLE %s%s SET SCHEMA %s", this.ignoreIfTableNotExists ? "IF EXISTS " : "", this.tableIdentifier.asSummaryString(), this.catalogTable.getUnresolvedSchema().toString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ctx.getCatalogManager().alterTable(this.getCatalogTable(), this.getTableIdentifier(), this.ignoreIfTableNotExists());
        return TableResultImpl.TABLE_RESULT_OK;
    }
}

