/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.hashtable;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.hashtable.BinaryHashPartition;
import org.apache.flink.table.runtime.hashtable.BinaryHashTable;
import org.apache.flink.table.runtime.util.RowIterator;
import org.apache.flink.util.MathUtils;

public class LookupBucketIterator
implements RowIterator<BinaryRowData> {
    private final BinaryHashTable table;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private MemorySegment bucket;
    private MemorySegment[] overflowSegments;
    private BinaryHashPartition partition;
    private int bucketInSegmentOffset;
    private int pointerOffset;
    private int searchHashCode;
    private int hashCodeOffset;
    private int countInBucket;
    private int numInBucket;
    private BinaryRowData reuse;
    private BinaryRowData instance;

    LookupBucketIterator(BinaryHashTable table) {
        this.table = table;
        this.reuse = table.binaryBuildSideSerializer.createInstance();
        this.segmentSizeBits = MathUtils.log2strict((int)table.pageSize());
        this.segmentSizeMask = table.pageSize() - 1;
    }

    public void set(MemorySegment bucket, MemorySegment[] overflowSegments, BinaryHashPartition partition, int searchHashCode, int bucketInSegmentOffset) {
        this.bucket = bucket;
        this.overflowSegments = overflowSegments;
        this.partition = partition;
        this.searchHashCode = searchHashCode;
        this.bucketInSegmentOffset = bucketInSegmentOffset;
        this.pointerOffset = bucketInSegmentOffset + 68;
        this.hashCodeOffset = this.bucketInSegmentOffset + 8;
        this.countInBucket = bucket.getShort(bucketInSegmentOffset + 0);
        this.numInBucket = 0;
    }

    @Override
    public boolean advanceNext() {
        while (this.countInBucket != 0) {
            this.table.probedSet.setMemorySegment(this.bucket, this.bucketInSegmentOffset + 2);
            while (this.numInBucket < this.countInBucket) {
                int thisCode = this.bucket.getInt(this.hashCodeOffset);
                this.hashCodeOffset += 4;
                ++this.numInBucket;
                if (thisCode == this.searchHashCode) {
                    int pointer = this.bucket.getInt(this.pointerOffset);
                    this.pointerOffset += 4;
                    try {
                        this.partition.setReadPosition(pointer);
                        BinaryRowData row = this.table.binaryBuildSideSerializer.mapFromPages(this.reuse, (AbstractPagedInputView)this.partition);
                        if (!this.table.applyCondition(row)) continue;
                        if (this.table.type.needSetProbed()) {
                            this.table.probedSet.set(this.numInBucket - 1);
                        }
                        this.instance = row;
                        return true;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error deserializing key or value from the hashtable: " + e.getMessage(), e);
                    }
                }
                this.pointerOffset += 4;
            }
            int forwardPointer = this.bucket.getInt(this.bucketInSegmentOffset + 4);
            if (forwardPointer == -1) {
                this.instance = null;
                return false;
            }
            int overflowSegIndex = forwardPointer >>> this.segmentSizeBits;
            this.bucket = this.overflowSegments[overflowSegIndex];
            this.bucketInSegmentOffset = forwardPointer & this.segmentSizeMask;
            this.pointerOffset = this.bucketInSegmentOffset + 68;
            this.countInBucket = this.bucket.getShort(this.bucketInSegmentOffset + 0);
            this.hashCodeOffset = this.bucketInSegmentOffset + 8;
            this.numInBucket = 0;
        }
        this.instance = null;
        return false;
    }

    @Override
    public BinaryRowData getRow() {
        return this.instance;
    }
}

