/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.slf4j;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.AbstractReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jReporter
extends AbstractReporter
implements Scheduled {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jReporter.class);
    private static final String lineSeparator = System.lineSeparator();
    private int previousSize = 16384;

    @VisibleForTesting
    Map<Gauge<?>, String> getGauges() {
        return this.gauges;
    }

    @VisibleForTesting
    Map<Counter, String> getCounters() {
        return this.counters;
    }

    @VisibleForTesting
    Map<Histogram, String> getHistograms() {
        return this.histograms;
    }

    @VisibleForTesting
    Map<Meter, String> getMeters() {
        return this.meters;
    }

    public void open(MetricConfig metricConfig) {
    }

    public void close() {
    }

    public void report() {
        try {
            this.tryReport();
        }
        catch (ConcurrentModificationException | NoSuchElementException runtimeException) {
            // empty catch block
        }
    }

    private void tryReport() {
        if (this.gauges.isEmpty() && this.counters.isEmpty() && this.histograms.isEmpty() && this.meters.isEmpty()) {
            LOG.info("Skipping metrics report because no metrics are registered.");
            return;
        }
        StringBuilder builder = new StringBuilder((int)((double)this.previousSize * 1.1));
        builder.append(lineSeparator).append("=========================== Starting metrics report ===========================").append(lineSeparator);
        Slf4jReporter.report(builder, "Counters", this.counters, Counter::getCount);
        Slf4jReporter.report(builder, "Gauges", this.gauges, Gauge::getValue);
        Slf4jReporter.report(builder, "Meters", this.meters, Meter::getRate);
        Slf4jReporter.report(builder, "Histograms", this.histograms, (T metric, StringBuilder b) -> {
            HistogramStatistics stats = metric.getStatistics();
            b.append("count=").append(stats.size()).append(", min=").append(stats.getMin()).append(", max=").append(stats.getMax()).append(", mean=").append(stats.getMean()).append(", stddev=").append(stats.getStdDev()).append(", p50=").append(stats.getQuantile(0.5)).append(", p75=").append(stats.getQuantile(0.75)).append(", p95=").append(stats.getQuantile(0.95)).append(", p98=").append(stats.getQuantile(0.98)).append(", p99=").append(stats.getQuantile(0.99)).append(", p999=").append(stats.getQuantile(0.999));
        });
        builder.append(lineSeparator).append("=========================== Finished metrics report ===========================").append(lineSeparator);
        LOG.info(builder.toString());
        this.previousSize = builder.length();
    }

    private static <T extends Metric> void report(StringBuilder builder, String type, Map<T, String> metrics, Function<T, Object> valueExtractor) {
        Slf4jReporter.report(builder, type, metrics, (T metric, StringBuilder build) -> builder.append(valueExtractor.apply(metric)));
    }

    private static <T extends Metric> void report(StringBuilder builder, String type, Map<T, String> metrics, BiConsumer<T, StringBuilder> valueExtractor) {
        if (!metrics.isEmpty()) {
            builder.append(lineSeparator).append("-- ").append(type).append(" ---------------------------------------------------------------------").append(lineSeparator);
            for (Map.Entry<T, String> metric : metrics.entrySet()) {
                builder.append(metric.getValue()).append(": ");
                valueExtractor.accept(metric.getKey(), builder);
                builder.append(lineSeparator);
            }
        }
    }

    public String filterCharacters(String input) {
        return input;
    }
}

