/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.StagedSinkModifyOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;

@Internal
public class ReplaceTableAsOperation
implements ModifyOperation {
    private final CreateTableOperation createTableOperation;
    private final QueryOperation sinkModifyQuery;
    private final boolean isCreateOrReplace;

    public ReplaceTableAsOperation(CreateTableOperation createTableOperation, QueryOperation sinkModifyQuery, boolean isCreateOrReplace) {
        this.createTableOperation = createTableOperation;
        this.sinkModifyQuery = sinkModifyQuery;
        this.isCreateOrReplace = isCreateOrReplace;
    }

    @Override
    public QueryOperation getChild() {
        return this.sinkModifyQuery;
    }

    @Override
    public <T> T accept(ModifyOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public CreateTableOperation getCreateTableOperation() {
        return this.createTableOperation;
    }

    public boolean isCreateOrReplace() {
        return this.isCreateOrReplace;
    }

    public SinkModifyOperation toSinkModifyOperation(CatalogManager catalogManager) {
        return new SinkModifyOperation(catalogManager.getTableOrError(this.createTableOperation.getTableIdentifier()), this.sinkModifyQuery, Collections.emptyMap(), null, false, Collections.emptyMap());
    }

    public StagedSinkModifyOperation toStagedSinkModifyOperation(ObjectIdentifier tableIdentifier, ResolvedCatalogTable catalogTable, Catalog catalog, DynamicTableSink dynamicTableSink) {
        return new StagedSinkModifyOperation(ContextResolvedTable.permanent(tableIdentifier, catalog, catalogTable), this.sinkModifyQuery, Collections.emptyMap(), (int[][])null, false, Collections.emptyMap(), dynamicTableSink);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogTable", this.getCreateTableOperation().getCatalogTable());
        params.put("identifier", this.getCreateTableOperation().getTableIdentifier());
        return OperationUtils.formatWithChildren(this.isCreateOrReplace ? "CREATE OR REPLACE TABLE AS" : "REPLACE TABLE AS", params, Collections.singletonList(this.sinkModifyQuery), Operation::asSummaryString);
    }
}

