/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.ModifyOperationVisitor;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;

@Internal
public class OutputConversionModifyOperation
implements ModifyOperation {
    private final QueryOperation child;
    private final DataType type;
    private final UpdateMode updateMode;

    public OutputConversionModifyOperation(QueryOperation child, DataType type, UpdateMode updateMode) {
        this.child = child;
        this.type = type;
        this.updateMode = updateMode;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public DataType getType() {
        return this.type;
    }

    @Override
    public QueryOperation getChild() {
        return this.child;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("updateMode", (Object)this.updateMode);
        params.put("type", this.type);
        return OperationUtils.formatWithChildren("Output", params, Collections.singletonList(this.child), Operation::asSummaryString);
    }

    public <R> R accept(ModifyOperationVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Internal
    public static enum UpdateMode {
        APPEND,
        RETRACT,
        UPSERT;

    }
}

