/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.flink.table.client.cli.CliStrings;
import org.apache.flink.table.client.cli.CliView;
import org.apache.flink.table.client.cli.TerminalUtils;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class CliInputView
extends CliView<InputOperation, String> {
    private final String inputTitle;
    private final Predicate<String> validation;
    private final StringBuilder currentInput;
    private int cursorPos;
    private boolean isError;

    public CliInputView(Terminal terminal, String inputTitle, Predicate<String> validation) {
        super(terminal);
        this.inputTitle = inputTitle;
        this.validation = validation;
        this.currentInput = new StringBuilder();
        this.cursorPos = 0;
    }

    @Override
    protected void init() {
    }

    @Override
    protected KeyMap<InputOperation> getKeys() {
        KeyMap<InputOperation> keys = new KeyMap<InputOperation>();
        keys.setUnicode(InputOperation.INSERT);
        keys.setAmbiguousTimeout(200L);
        for (char i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            keys.bind(InputOperation.INSERT, (CharSequence)Character.toString(i));
        }
        keys.bind(InputOperation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        keys.bind(InputOperation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        keys.bind(InputOperation.BACKSPACE, (CharSequence)KeyMap.del());
        if (TerminalUtils.isPlainTerminal(this.terminal)) {
            keys.bind(InputOperation.ENTER, "\r", "$");
            keys.bind(InputOperation.QUIT, KeyMap.key(this.terminal, InfoCmp.Capability.key_exit), "!");
        } else {
            keys.bind(InputOperation.ENTER, (CharSequence)"\r");
            keys.bind(InputOperation.QUIT, (CharSequence)KeyMap.esc());
        }
        return keys;
    }

    @Override
    protected void evaluate(InputOperation operation, String binding) {
        switch (operation) {
            case QUIT: {
                this.close();
                break;
            }
            case INSERT: {
                this.insert(binding);
                break;
            }
            case ENTER: {
                this.submit();
                break;
            }
            case LEFT: {
                this.moveCursorLeft();
                break;
            }
            case RIGHT: {
                this.moveCursorRight();
                break;
            }
            case BACKSPACE: {
                this.deleteLeft();
            }
        }
    }

    @Override
    protected String getTitle() {
        return "Input Dialog";
    }

    @Override
    protected List<AttributedString> computeHeaderLines() {
        return Collections.emptyList();
    }

    @Override
    protected List<AttributedString> computeFooterLines() {
        return Collections.singletonList(CliStrings.INPUT_HELP);
    }

    @Override
    protected List<AttributedString> computeMainHeaderLines() {
        return Collections.emptyList();
    }

    @Override
    protected List<AttributedString> computeMainLines() {
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        IntStream.range(0, this.getVisibleMainHeight() / 2 - 2).forEach(i -> lines.add(AttributedString.EMPTY));
        lines.add(new AttributedString(" " + this.inputTitle));
        AttributedStringBuilder inputLine = new AttributedStringBuilder();
        inputLine.append(" > ");
        String input = this.currentInput.toString();
        inputLine.append(this.currentInput.substring(0, this.cursorPos));
        inputLine.style(AttributedStyle.DEFAULT.inverse().blink());
        if (this.cursorPos < input.length()) {
            inputLine.append(input.charAt(this.cursorPos));
            inputLine.style(AttributedStyle.DEFAULT);
            inputLine.append(input.substring(this.cursorPos + 1, input.length()));
        } else {
            inputLine.append(' ');
        }
        lines.add(inputLine.toAttributedString());
        if (this.isError) {
            AttributedStringBuilder errorLine = new AttributedStringBuilder();
            errorLine.style(AttributedStyle.DEFAULT.foreground(1));
            errorLine.append(" The input is invalid please check it again.");
            lines.add(AttributedString.EMPTY);
            lines.add(errorLine.toAttributedString());
        }
        return lines;
    }

    @Override
    protected void cleanUp() {
    }

    private void insert(String binding) {
        this.currentInput.insert(this.cursorPos, binding);
        this.cursorPos += binding.length();
        this.resetMainPart();
    }

    private void deleteLeft() {
        if (this.cursorPos > 0) {
            this.currentInput.deleteCharAt(this.cursorPos - 1);
            --this.cursorPos;
        }
        this.resetMainPart();
    }

    private void moveCursorLeft() {
        if (this.cursorPos > 0) {
            --this.cursorPos;
        }
        this.resetMainPart();
    }

    private void moveCursorRight() {
        if (this.cursorPos < this.currentInput.length()) {
            ++this.cursorPos;
        }
        this.resetMainPart();
    }

    private void submit() {
        this.isError = false;
        String s = this.currentInput.toString();
        if (s.isEmpty()) {
            this.close();
        } else if (this.validation.test(s)) {
            this.close(s);
        } else {
            this.isError = true;
            this.resetMainPart();
        }
    }

    public static enum InputOperation {
        QUIT,
        INSERT,
        ENTER,
        LEFT,
        RIGHT,
        BACKSPACE;

    }
}

