/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.client;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicates;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;

import javax.validation.constraints.NotNull;

/**
 */
public class HttpServerInventoryViewProvider implements ServerInventoryViewProvider
{
  @JacksonInject
  @NotNull
  @EscalatedClient
  HttpClient httpClient = null;

  @JacksonInject
  @NotNull
  @Smile
  ObjectMapper smileMapper = null;

  @JacksonInject
  @NotNull
  HttpServerInventoryViewConfig config = null;

  @JacksonInject
  @NotNull
  private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = null;

  @JacksonInject
  @NotNull
  private ScheduledExecutorFactory executorFactory;

  @JacksonInject
  @NotNull
  private ServiceEmitter serviceEmitter = null;

  @Override
  public HttpServerInventoryView get()
  {
    return new HttpServerInventoryView(
        smileMapper,
        httpClient,
        druidNodeDiscoveryProvider,
        Predicates.alwaysTrue(),
        config,
        serviceEmitter,
        executorFactory,
        "HttpServerInventoryView"
    );
  }
}
