/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;

final class FindHelper {
    private FindHelper() {
    }

    public static SourceElement findTable(SourceElement root, String tableName, boolean searchExternalSchemata) {
        if (!TorqueSchemaElementName.DATABASE.getName().equals(root.getName())) {
            throw new IllegalArgumentException("Wrong source element " + root.getName());
        }
        for (SourceElement table : root.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
            if (!tableName.equals(table.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME))) continue;
            return table;
        }
        if (searchExternalSchemata) {
            return root.getChildren((SourceElementName)TorqueSchemaElementName.EXTERNAL_SCHEMA).stream().map(externalSchema -> externalSchema.getChild((SourceElementName)TorqueSchemaElementName.DATABASE)).map(databaseElement -> FindHelper.findTable(databaseElement, tableName, searchExternalSchemata)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public static SourceElement findColumn(SourceElement table, String columnName) {
        if (!TorqueSchemaElementName.TABLE.getName().equals(table.getName())) {
            throw new IllegalArgumentException("Wrong source element " + table.getName());
        }
        return table.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN).stream().filter(column -> column.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME).equals(columnName)).findFirst().orElse(null);
    }

    public static List<SourceElement> findForeignKeyByReferencedTable(SourceElement table, String tableName) {
        if (!TorqueSchemaElementName.TABLE.getName().equals(table.getName())) {
            throw new IllegalArgumentException("Wrong source element " + table.getName());
        }
        List<SourceElement> result = table.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY).stream().filter(foreignKey -> foreignKey.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.FOREIGN_TABLE).equals(tableName)).collect(Collectors.toList());
        return result;
    }
}

