/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class RemoteCacheNoWaitFacade<K, V>
extends AbstractRemoteCacheNoWaitFacade<K, V> {
    private static final Log log = LogManager.getLog(RemoteCacheNoWaitFacade.class);
    private final RemoteCacheFactory cacheFactory;
    protected boolean attemptRestorePrimary = true;
    private static final long idlePeriod = 20000L;

    public RemoteCacheNoWaitFacade(List<RemoteCacheNoWait<K, V>> noWaits, IRemoteCacheAttributes rca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer, RemoteCacheFactory cacheFactory) {
        super(noWaits, rca, cacheEventLogger, elementSerializer);
        this.cacheFactory = cacheFactory;
    }

    @Override
    protected void failover(RemoteCacheNoWait<K, V> rcnw) {
        log.debug("in failover for {0}", rcnw);
        if (this.getAuxiliaryCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            if (rcnw.getStatus() == CacheStatus.ERROR) {
                Thread runner = new Thread(this::connectAndRestore);
                runner.setDaemon(true);
                runner.start();
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logApplicationEvent("RemoteCacheNoWaitFacade", "InitiatedFailover", rcnw + " was in error.");
                }
            } else {
                log.info("The noWait is not in error");
            }
        }
    }

    protected void connectAndRestore() {
        IRemoteCacheAttributes rca0 = this.getAuxiliaryCacheAttributes();
        List<RemoteLocation> failovers = rca0.getFailovers();
        if (failovers == null) {
            log.warn("Remote is misconfigured, failovers was null.");
            return;
        }
        if (failovers.size() == 1) {
            log.info("No failovers defined, exiting failover runner.");
            return;
        }
        AtomicBoolean allright = new AtomicBoolean(false);
        do {
            log.info("Remote cache FAILOVER RUNNING.");
            if (!allright.get()) {
                int fidx = rca0.getFailoverIndex();
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = rca0::getFailoverIndex;
                supplierArray[1] = failovers::size;
                log.debug("fidx = {0} failovers.size = {1}", supplierArray);
                ListIterator<RemoteLocation> i = failovers.listIterator(fidx);
                log.debug("starting at failover i = {0}", i);
                while (i.hasNext() && !allright.get()) {
                    RemoteCacheNoWait ic;
                    int failoverIndex = i.nextIndex();
                    RemoteLocation server = i.next();
                    log.debug("Trying server [{0}] at failover index i = {1}", server, failoverIndex);
                    RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
                    rca.setRemoteLocation(server);
                    RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
                    log.debug("RemoteCacheAttributes for failover = {0}", rca);
                    if (rcm == null || (ic = rcm.getCache(rca)).getStatus() != CacheStatus.ALIVE) continue;
                    log.debug("resetting no wait");
                    this.restorePrimaryServer(ic);
                    rca0.setFailoverIndex(failoverIndex);
                    log.debug("setting ALLRIGHT to true");
                    if (i.hasPrevious()) {
                        log.debug("Moving to Primary Recovery Mode, failover index = {0}", failoverIndex);
                    } else {
                        log.debug("No need to connect to failover, the primary server is back up.");
                    }
                    allright.set(true);
                    Supplier[] supplierArray2 = new Supplier[1];
                    supplierArray2[0] = rca::getRemoteLocation;
                    log.info("CONNECTED to host = [{0}]", supplierArray2);
                }
            } else {
                log.debug("ALLRIGHT is true ");
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = rca0::getFailoverIndex;
                log.info("Failover runner is in primary recovery mode. Failover index = {0} Will now try to reconnect to primary server.", supplierArray);
            }
            if (allright.get() && !this.attemptRestorePrimary) break;
            boolean primaryRestoredSuccessfully = false;
            if (rca0.getFailoverIndex() > 0) {
                primaryRestoredSuccessfully = this.restorePrimary();
                log.debug("Primary recovery success state = {0}", primaryRestoredSuccessfully);
            }
            if (primaryRestoredSuccessfully) continue;
            try {
                log.warn("Failed to reconnect to primary server. Cache failover runner is going to sleep for {0} milliseconds.", 20000L);
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (rca0.getFailoverIndex() > 0 || !allright.get());
        if (log.isInfoEnabled()) {
            int failoverIndex = rca0.getFailoverIndex();
            log.info("Exiting failover runner. Failover index = {0}", failoverIndex);
            if (failoverIndex <= 0) {
                log.info("Failover index is <= 0, meaning we are not connected to a failover server.");
            } else {
                log.info("Failover index is > 0, meaning we are connected to a failover server.");
            }
        }
    }

    private boolean restorePrimary() {
        RemoteCacheNoWait ic;
        IRemoteCacheAttributes rca0 = this.getAuxiliaryCacheAttributes();
        RemoteLocation server = rca0.getFailovers().get(0);
        log.info("Trying to restore connection to primary remote server [{0}]", server);
        RemoteCacheAttributes rca = (RemoteCacheAttributes)rca0.clone();
        rca.setRemoteLocation(server);
        RemoteCacheManager rcm = this.cacheFactory.getManager(rca);
        if (rcm != null && (ic = rcm.getCache(rca)).getStatus() == CacheStatus.ALIVE) {
            try {
                if (this.getPrimaryServer() != null && this.getPrimaryServer().getStatus() == CacheStatus.ALIVE) {
                    int fidx = rca0.getFailoverIndex();
                    if (fidx > 0) {
                        RemoteLocation serverOld = rca0.getFailovers().get(fidx);
                        log.debug("Failover Index = {0} the server at that index is [{1}]", fidx, serverOld);
                        if (serverOld != null) {
                            RemoteCacheAttributes rcaOld = (RemoteCacheAttributes)rca0.clone();
                            rcaOld.setRemoteLocation(serverOld);
                            RemoteCacheManager rcmOld = this.cacheFactory.getManager(rcaOld);
                            if (rcmOld != null) {
                                rcmOld.removeRemoteCacheListener(rcaOld);
                            }
                            log.info("Successfully deregistered from FAILOVER remote server = {0}", serverOld);
                        }
                    } else if (fidx == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("No need to restore primary, it is already restored.");
                            return true;
                        }
                    } else {
                        log.warn("Failover index is less than 0, this shouldn't happen");
                    }
                }
            }
            catch (IOException e) {
                log.error("Trouble trying to deregister old failover listener prior to restoring the primary = {0}", server, e);
            }
            RemoteCacheNoWait failoverNoWait = this.getPrimaryServer();
            this.restorePrimaryServer(ic);
            rca0.setFailoverIndex(0);
            String message = "Successfully reconnected to PRIMARY remote server. Substituted primary for failoverNoWait [" + failoverNoWait + "]";
            log.info(message);
            if (this.getCacheEventLogger() != null) {
                this.getCacheEventLogger().logApplicationEvent("RemoteCacheFailoverRunner", "RestoredPrimary", message);
            }
            return true;
        }
        log.debug("Primary server status in error, not connected.");
        return false;
    }
}

