/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DoubleLinkedList<T extends DoubleLinkedListNode> {
    private int size = 0;
    private static final Log log = LogFactory.getLog(DoubleLinkedList.class);
    private T first;
    private T last;

    public synchronized void addLast(T me) {
        if (this.first == null) {
            this.first = me;
        } else {
            ((DoubleLinkedListNode)this.last).next = me;
            ((DoubleLinkedListNode)me).prev = this.last;
        }
        this.last = me;
        ++this.size;
    }

    public synchronized void addFirst(T me) {
        if (this.last == null) {
            this.last = me;
        } else {
            ((DoubleLinkedListNode)this.first).prev = me;
            ((DoubleLinkedListNode)me).next = this.first;
        }
        this.first = me;
        ++this.size;
    }

    public synchronized T getLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning last node");
        }
        return this.last;
    }

    public synchronized T getFirst() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning first node");
        }
        return this.first;
    }

    public synchronized void makeFirst(T ln) {
        if (((DoubleLinkedListNode)ln).prev == null) {
            return;
        }
        ((DoubleLinkedListNode)ln).prev.next = ((DoubleLinkedListNode)ln).next;
        if (((DoubleLinkedListNode)ln).next == null) {
            this.last = ((DoubleLinkedListNode)ln).prev;
            ((DoubleLinkedListNode)this.last).next = null;
        } else {
            ((DoubleLinkedListNode)ln).next.prev = ((DoubleLinkedListNode)ln).prev;
        }
        ((DoubleLinkedListNode)this.first).prev = ln;
        ((DoubleLinkedListNode)ln).next = this.first;
        ((DoubleLinkedListNode)ln).prev = null;
        this.first = ln;
    }

    public synchronized void makeLast(T ln) {
        if (((DoubleLinkedListNode)ln).next == null) {
            return;
        }
        if (((DoubleLinkedListNode)ln).prev != null) {
            ((DoubleLinkedListNode)ln).prev.next = ((DoubleLinkedListNode)ln).next;
        } else {
            this.first = this.last;
        }
        if (this.last != null) {
            ((DoubleLinkedListNode)this.last).next = ln;
        }
        ((DoubleLinkedListNode)ln).prev = this.last;
        ((DoubleLinkedListNode)ln).next = null;
        this.last = ln;
    }

    public synchronized void removeAll() {
        Object me = this.first;
        while (me != null) {
            if (((DoubleLinkedListNode)me).prev != null) {
                ((DoubleLinkedListNode)me).prev = null;
            }
            DoubleLinkedListNode next = ((DoubleLinkedListNode)me).next;
            me = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized boolean remove(T me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing node");
        }
        if (((DoubleLinkedListNode)me).next == null) {
            if (((DoubleLinkedListNode)me).prev == null) {
                if (me == this.first && me == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = ((DoubleLinkedListNode)me).prev;
                ((DoubleLinkedListNode)this.last).next = null;
                ((DoubleLinkedListNode)me).prev = null;
            }
        } else if (((DoubleLinkedListNode)me).prev == null) {
            this.first = ((DoubleLinkedListNode)me).next;
            ((DoubleLinkedListNode)this.first).prev = null;
            ((DoubleLinkedListNode)me).next = null;
        } else {
            ((DoubleLinkedListNode)me).prev.next = ((DoubleLinkedListNode)me).next;
            ((DoubleLinkedListNode)me).next.prev = ((DoubleLinkedListNode)me).prev;
            ((DoubleLinkedListNode)me).next = null;
            ((DoubleLinkedListNode)me).prev = null;
        }
        --this.size;
        return true;
    }

    public synchronized T removeLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing last node");
        }
        T temp = this.last;
        if (this.last != null) {
            this.remove(this.last);
        }
        return temp;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void debugDumpEntries() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"dumping Entries");
            Object me = this.first;
            while (me != null) {
                log.debug((Object)("dump Entries> payload= '" + ((DoubleLinkedListNode)me).getPayload() + "'"));
                me = ((DoubleLinkedListNode)me).next;
            }
        }
    }
}

