/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs.engine.CacheStatus;

public class RemoteHttpCacheMonitor
extends AbstractAuxiliaryCacheMonitor {
    private final ConcurrentHashMap<RemoteHttpCache<?, ?>, RemoteHttpCache<?, ?>> remoteHttpCaches;
    private RemoteHttpCacheFactory factory = null;

    public RemoteHttpCacheMonitor(RemoteHttpCacheFactory factory) {
        super("JCS-RemoteHttpCacheMonitor");
        this.factory = factory;
        this.remoteHttpCaches = new ConcurrentHashMap();
        RemoteHttpCacheMonitor.setIdlePeriod(3000L);
    }

    public void notifyError(RemoteHttpCache<?, ?> remoteCache) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Notified of an error. " + remoteCache));
        }
        this.remoteHttpCaches.put(remoteCache, remoteCache);
        this.notifyError();
    }

    @Override
    protected void dispose() {
        this.remoteHttpCaches.clear();
    }

    @Override
    protected void doWork() {
        if (this.factory == null) {
            return;
        }
        for (RemoteHttpCache remoteHttpCache : this.remoteHttpCaches.values()) {
            try {
                if (remoteHttpCache.getStatus() != CacheStatus.ERROR) continue;
                RemoteHttpCacheAttributes attributes = remoteHttpCache.getRemoteHttpCacheAttributes();
                IRemoteHttpCacheClient remoteService = this.factory.createRemoteHttpCacheClientForAttributes(attributes);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Performing Alive check on service " + remoteService));
                }
                if (remoteService.isAlive()) {
                    remoteHttpCache.fixCache(remoteService);
                    break;
                }
                this.allright.set(false);
                break;
            }
            catch (IOException ex) {
                this.allright.set(false);
                this.log.error((Object)ex);
            }
        }
    }
}

