/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.SourcePath;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.TorqueSchemaIdMethod;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.platform.PlatformFactory;
import org.apache.torque.templates.transformer.CollectAttributeSetTrueTransformer;
import org.apache.torque.templates.transformer.IncludeSchemaTransformer;
import org.apache.torque.templates.transformer.LoadExternalSchemaTransformer;
import org.apache.torque.templates.transformer.SchemaTypeHelper;
import org.apache.torque.templates.transformer.om.DatabaseChildElementName;
import org.apache.torque.templates.transformer.om.OMColumnJavaTransformer;
import org.apache.torque.templates.transformer.om.OMTransformer;
import org.apache.torque.templates.transformer.om.TableChildElementName;
import org.apache.torque.templates.transformer.sql.SqlAttributeName;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;
import org.apache.torque.templates.typemapping.TypeMap;

public class SQLTransformer
implements SourceTransformer {
    private static final CollectAttributeSetTrueTransformer collectAttributeSetTrueTransformer = new CollectAttributeSetTrueTransformer();
    private static final SourceTransformer loadExternalSchemaTransformer = new LoadExternalSchemaTransformer();
    private static final SourceTransformer includeSchemaTransformer = new IncludeSchemaTransformer();

    public SourceElement transform(Object databaseModel, ControllerState controllerState) throws SourceTransformerException {
        SourceElement databaseElement = (SourceElement)databaseModel;
        OMTransformer.setRootDatabaseNameAttribute(databaseElement);
        includeSchemaTransformer.transform((Object)databaseElement, controllerState);
        loadExternalSchemaTransformer.transform((Object)databaseElement, controllerState);
        TemplateOptionName.checkRequiredOptions(controllerState, TemplateOptionName.DATABASE);
        List allTables = databaseElement.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES).getChildren((SourceElementName)TorqueSchemaElementName.TABLE);
        for (SourceElement tableElement : allTables) {
            this.transformTable(tableElement, controllerState);
        }
        this.addDatabaseSchemaElements(databaseElement, controllerState);
        return databaseElement;
    }

    public void transformTable(SourceElement tableElement, ControllerState controllerState) throws SourceTransformerException {
        String tableName;
        String unqualifiedTableName = tableName = (String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        if (StringUtils.contains((CharSequence)tableName, (CharSequence)".")) {
            unqualifiedTableName = tableName.substring(tableName.indexOf(".") + 1);
        }
        tableElement.setAttribute((SourceAttributeName)SqlAttributeName.UNQUALIFIED_NAME, (Object)unqualifiedTableName);
        Object idMethod = tableElement.getAttribute(TorqueSchemaAttributeName.ID_METHOD.getName());
        if (idMethod == null) {
            Object defaultIdMethod = tableElement.getParent().getAttribute(TorqueSchemaAttributeName.DEFAULT_ID_METHOD.getName());
            if (defaultIdMethod == null) {
                throw new SourceTransformerException("id Method is not set on table " + tableElement.getAttribute(TorqueSchemaAttributeName.NAME.getName()) + " and defaultIdMethod is not set on database");
            }
            tableElement.setAttribute(TorqueSchemaAttributeName.ID_METHOD.getName(), defaultIdMethod);
        }
        if (tableElement.getAttribute((SourceAttributeName)SqlAttributeName.PRIMARY_KEY_CONSTRAINT_NAME) == null) {
            String primaryKeyConstraintName = unqualifiedTableName + "_PK";
            tableElement.setAttribute((SourceAttributeName)SqlAttributeName.PRIMARY_KEY_CONSTRAINT_NAME, (Object)primaryKeyConstraintName);
        }
        if (tableElement.getAttribute((SourceAttributeName)SqlAttributeName.SEQUENCE_NAME) == null) {
            String sequenceName = null;
            SourceElement idMethodParameterElement = tableElement.getChild((SourceElementName)TorqueSchemaElementName.ID_METHOD_PARAMETER);
            if (idMethodParameterElement != null) {
                sequenceName = (String)idMethodParameterElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.VALUE);
            }
            if (StringUtils.isBlank(sequenceName)) {
                sequenceName = tableName + "_SEQ";
            }
            tableElement.setAttribute((SourceAttributeName)SqlAttributeName.SEQUENCE_NAME, (Object)sequenceName);
        }
        collectAttributeSetTrueTransformer.transform(tableElement, controllerState, TorqueSchemaElementName.COLUMN, TorqueSchemaAttributeName.PRIMARY_KEY, TableChildElementName.PRIMARY_KEYS);
        StringBuilder primaryKeyColumnNames = new StringBuilder();
        SourceElement primaryKeysElement = tableElement.getChild((SourceElementName)TableChildElementName.PRIMARY_KEYS);
        boolean firstPk = true;
        for (Object primaryKeyColumn : primaryKeysElement.getChildren()) {
            if (!firstPk) {
                primaryKeyColumnNames.append(", ");
            }
            primaryKeyColumnNames.append(primaryKeyColumn.getAttribute(TorqueSchemaAttributeName.NAME.getName()));
            firstPk = false;
        }
        tableElement.setAttribute((SourceAttributeName)SqlAttributeName.PRIMARY_KEY_COLUMN_NAMES, (Object)primaryKeyColumnNames.toString());
        int uniqueIndex = 1;
        for (Object uniqueElement : tableElement.getChildren(TorqueSchemaElementName.UNIQUE.getName())) {
            if (uniqueElement.getAttribute(TorqueSchemaAttributeName.NAME.getName()) == null) {
                uniqueElement.setAttribute(TorqueSchemaAttributeName.NAME.getName(), (Object)(uniqueElement.getParent().getAttribute(TorqueSchemaAttributeName.NAME.getName()) + "_UQ_" + uniqueIndex));
            }
            String uniqueColumnNames = this.collectAttributes((SourceElement)uniqueElement, TorqueSchemaElementName.UNIQUE_COLUMN.getName(), TorqueSchemaAttributeName.NAME.getName());
            uniqueElement.setAttribute((SourceAttributeName)SqlAttributeName.UNIQUE_COLUMN_NAMES, (Object)uniqueColumnNames);
            String uniqueColumnSizes = this.collectAttributes((SourceElement)uniqueElement, TorqueSchemaElementName.UNIQUE_COLUMN.getName(), TorqueSchemaAttributeName.SIZE.getName());
            uniqueElement.setAttribute((SourceAttributeName)SqlAttributeName.UNIQUE_COLUMN_SIZES, (Object)uniqueColumnSizes);
            ++uniqueIndex;
        }
        int indexIndex = 1;
        for (Object indexElement : tableElement.getChildren(TorqueSchemaElementName.INDEX.getName())) {
            if (indexElement.getAttribute(TorqueSchemaAttributeName.NAME.getName()) == null) {
                indexElement.setAttribute(TorqueSchemaAttributeName.NAME.getName(), (Object)(indexElement.getParent().getAttribute(TorqueSchemaAttributeName.NAME.getName()) + "_IDX_" + indexIndex));
            }
            String indexColumnNames = this.collectAttributes((SourceElement)indexElement, TorqueSchemaElementName.INDEX_COLUMN.getName(), TorqueSchemaAttributeName.NAME.getName());
            indexElement.setAttribute((SourceAttributeName)SqlAttributeName.INDEX_COLUMN_NAMES, (Object)indexColumnNames);
            ++indexIndex;
        }
        List columnElements = tableElement.getChildren(TorqueSchemaElementName.COLUMN.getName());
        for (SourceElement columnElement : columnElements) {
            this.transformColumn(columnElement, controllerState);
        }
        List foreignKeyElements = tableElement.getChildren(TorqueSchemaElementName.FOREIGN_KEY.getName());
        int fkIndex = 1;
        for (SourceElement foreignKeyElemenElement : foreignKeyElements) {
            this.transformForeignKey(foreignKeyElemenElement, controllerState, fkIndex);
            ++fkIndex;
        }
    }

    private void transformColumn(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        String sql = (String)columnElement.getAttribute((SourceAttributeName)SqlAttributeName.DDL_SQL);
        if (sql == null) {
            sql = this.getDdlSql(columnElement, controllerState);
            columnElement.setAttribute((SourceAttributeName)SqlAttributeName.DDL_SQL, (Object)sql);
        }
    }

    private String getDdlSql(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        String autoIncrement;
        SchemaType schemaType = SchemaTypeHelper.getSchemaType(columnElement, controllerState);
        SqlType domainType = SchemaTypeHelper.getDomain(columnElement, controllerState);
        Object size = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE);
        Object scale = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE);
        Object defaultValue = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT);
        SqlType sqlType = SchemaTypeHelper.getSqlType(schemaType, domainType, controllerState, Objects.toString(size, null), Objects.toString(scale, null), Objects.toString(defaultValue, null));
        Platform platform = this.getPlatform(controllerState);
        ArrayList<String> resultList = new ArrayList<String>();
        String sqlTypeName = sqlType.getSqlTypeName();
        if (platform.hasSize(sqlTypeName)) {
            sqlTypeName = sqlTypeName + sqlType.printSize(platform.getSizeSuffix(sqlTypeName));
        }
        if (platform.hasScale(sqlTypeName)) {
            sqlTypeName = sqlTypeName + sqlType.printScale();
        }
        resultList.add(sqlTypeName);
        if (StringUtils.isNotEmpty((CharSequence)sqlType.getDefaultValue())) {
            resultList.add("default");
            if (SchemaType.DATE == schemaType || SchemaType.TIME == schemaType || SchemaType.TIMESTAMP == schemaType) {
                if (sqlType.getDefaultValue().startsWith("CURRENT_")) {
                    resultList.add(sqlType.getDefaultValue());
                } else {
                    Date defaultDate = OMColumnJavaTransformer.getDefaultValueAsDate(sqlType.getDefaultValue());
                    if (SchemaType.DATE == schemaType) {
                        resultList.add(platform.getDateString(defaultDate));
                    } else if (SchemaType.TIME == schemaType) {
                        resultList.add(platform.getTimeString(defaultDate));
                    } else {
                        resultList.add(platform.getTimestampString(defaultDate));
                    }
                }
            } else if (TypeMap.isTextType(schemaType)) {
                resultList.add(platform.quoteAndEscape(sqlType.getDefaultValue()));
            } else {
                resultList.add(sqlType.getDefaultValue());
            }
        }
        String primaryKeyString = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PRIMARY_KEY);
        boolean primaryKey = Boolean.parseBoolean(primaryKeyString);
        String requiredString = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.REQUIRED);
        boolean required = Boolean.parseBoolean(requiredString);
        boolean isNotNull = primaryKey || required;
        String isNotNullString = platform.getNullString(isNotNull);
        if (platform.createNotNullBeforeAutoincrement() && StringUtils.isNotEmpty((CharSequence)isNotNullString)) {
            resultList.add(isNotNullString);
        }
        Object idMethod = columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD);
        if (primaryKey && TorqueSchemaIdMethod.NATIVE.getName().equals(idMethod) && StringUtils.isNotEmpty((CharSequence)(autoIncrement = platform.getAutoIncrement()))) {
            resultList.add(autoIncrement);
        }
        if (!platform.createNotNullBeforeAutoincrement() && StringUtils.isNotEmpty((CharSequence)isNotNullString)) {
            resultList.add(isNotNullString);
        }
        return StringUtils.join(resultList.iterator(), (char)' ');
    }

    private Platform getPlatform(ControllerState controllerState) {
        Platform platform = PlatformFactory.getPlatformFor(controllerState.getStringOption((OptionName)TemplateOptionName.DATABASE));
        return platform;
    }

    private void transformForeignKey(SourceElement foreignKeyElement, ControllerState controllerState, int fkIndex) {
        if (foreignKeyElement.getAttribute(TorqueSchemaAttributeName.NAME.getName()) == null) {
            foreignKeyElement.setAttribute(TorqueSchemaAttributeName.NAME.getName(), (Object)(foreignKeyElement.getParent().getAttribute(TorqueSchemaAttributeName.NAME.getName()) + "_FK_" + fkIndex));
        }
        String localColumnsNames = this.collectAttributes(foreignKeyElement, TorqueSchemaElementName.REFERENCE.getName(), TorqueSchemaAttributeName.LOCAL.getName());
        foreignKeyElement.setAttribute((SourceAttributeName)SqlAttributeName.LOCAL_COLUMN_NAMES, (Object)localColumnsNames);
        String foreignColumnsNames = this.collectAttributes(foreignKeyElement, TorqueSchemaElementName.REFERENCE.getName(), TorqueSchemaAttributeName.FOREIGN.getName());
        foreignKeyElement.setAttribute((SourceAttributeName)SqlAttributeName.FOREIGN_COLUMN_NAMES, (Object)foreignColumnsNames);
    }

    private void addDatabaseSchemaElements(SourceElement databaseElement, ControllerState controllerState) {
        Platform platform = this.getPlatform(controllerState);
        if (!platform.usesStandaloneSchema()) {
            return;
        }
        ArrayList<String> databaseSchemaNames = new ArrayList<String>();
        List allTables = databaseElement.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES).getChildren((SourceElementName)TorqueSchemaElementName.TABLE);
        for (SourceElement tableElement : allTables) {
            String databaseSchema;
            String name = (String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            if (!StringUtils.contains((CharSequence)name, (int)46) || databaseSchemaNames.contains(databaseSchema = name.substring(0, name.indexOf(46)))) continue;
            databaseSchemaNames.add(databaseSchema);
        }
        for (String databaseSchemaName : databaseSchemaNames) {
            SourceElement databaseSchemaElement = new SourceElement("databaseSchema");
            databaseSchemaElement.setAttribute("name", (Object)databaseSchemaName);
            databaseElement.getChildren().add(databaseSchemaElement);
        }
    }

    private String collectAttributes(SourceElement rootElement, String sourcePath, String attributeName) {
        StringBuilder result = new StringBuilder();
        List toCollectFrom = SourcePath.getElements((SourceElement)rootElement, (String)sourcePath);
        for (SourceElement sourceElement : toCollectFrom) {
            Object attributeValue = sourceElement.getAttribute(attributeName);
            if (attributeValue == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(sourceElement.getAttribute(attributeName));
        }
        return result.toString();
    }
}

