/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om.mapInit;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.AttributeTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.LoadExternalSchemaTransformer;
import org.apache.torque.templates.transformer.om.DatabaseAttributeName;
import org.apache.torque.templates.transformer.om.DatabaseChildElementName;
import org.apache.torque.templates.transformer.om.OMTransformer;
import org.apache.torque.templates.transformer.om.mapInit.DatabaseMapInitTableTransformer;

public class DatabaseMapInitTransformer
extends AttributeTransformer {
    private static Camelbacker camelbacker = new Camelbacker();
    private static final String DATABASE_SETS_ELEMENT = "databaseSets";
    private static final String DATABASE_SET_ELEMENT = "databaseSet";
    private final DatabaseMapInitTableTransformer tableTransformer = new DatabaseMapInitTableTransformer();

    public DatabaseMapInitTransformer() throws SourceTransformerException {
        super(DatabaseMapInitTransformer.getTransformerProperties());
    }

    private static Reader getTransformerProperties() {
        try {
            return new InputStreamReader(DatabaseMapInitTransformer.class.getResourceAsStream("DatabaseMapInitTransformer.properties"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public SourceElement transform(Object modelRoot, ControllerState controllerState) throws SourceTransformerException {
        SourceElement rootElement = (SourceElement)modelRoot;
        if (!"source".equals(rootElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + rootElement.getName());
        }
        SourceElement databaseSetsElement = new SourceElement(DATABASE_SETS_ELEMENT);
        rootElement.getChildren().add(databaseSetsElement);
        for (SourceElement fileElement : rootElement.getChildren("file")) {
            SourceElement databaseElement = fileElement.getChild((SourceElementName)TorqueSchemaElementName.DATABASE);
            if (databaseElement == null) {
                throw new IllegalArgumentException("The root element of file " + fileElement.getAttribute("path") + " is unknown, should be " + TorqueSchemaElementName.DATABASE.getName());
            }
            String name = (String)databaseElement.getAttribute(TorqueSchemaAttributeName.NAME.getName());
            if (name == null) {
                throw new SourceTransformerException("The attribute " + TorqueSchemaAttributeName.NAME.getName() + " on element " + databaseElement.getName() + " is null");
            }
            OMTransformer.setRootDatabaseNameAttribute(databaseElement);
            String path = (String)fileElement.getAttribute("path");
            File pathFile = new File(path);
            LoadExternalSchemaTransformer loadExternalSchemaTransformer = new LoadExternalSchemaTransformer(pathFile.getParentFile());
            loadExternalSchemaTransformer.transform(databaseElement, controllerState);
            SourceElement allTablesRoot = databaseElement.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES);
            SourceElement databaseSetElement = this.getDatabaseSetWithDatabaseName(databaseSetsElement, name);
            if (databaseSetElement == null) {
                databaseSetElement = new SourceElement(DATABASE_SET_ELEMENT);
                databaseSetElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME, (Object)name);
                databaseSetsElement.getChildren().add(databaseSetElement);
            }
            for (SourceElement tableElement : allTablesRoot.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
                databaseSetElement.getChildren().add(tableElement);
            }
        }
        for (SourceElement databaseSetElement : databaseSetsElement.getChildren(DATABASE_SET_ELEMENT)) {
            String name = (String)databaseSetElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            DatabaseMapInitTransformer.setDatabaseMapInitClassNameAttributes(databaseSetElement, name, controllerState);
            super.transform((Object)databaseSetElement, controllerState);
            for (SourceElement tableElement : databaseSetElement.getChildren((SourceElementName)TorqueSchemaElementName.TABLE)) {
                this.tableTransformer.transform(tableElement, controllerState);
            }
        }
        return rootElement;
    }

    public static void setDatabaseMapInitClassNameAttributes(SourceElement sourceElement, String databaseName, ControllerState controllerState) {
        String databaseMapInitClassName = controllerState.getOption((OptionName)TemplateOptionName.OM_DATABASE_MAP_INIT_CLASS_NAME_PREFIX) + camelbacker.process(databaseName) + controllerState.getOption((OptionName)TemplateOptionName.OM_DATABASE_MAP_INIT_CLASS_NAME_SUFFIX);
        sourceElement.setAttribute((SourceAttributeName)DatabaseAttributeName.DATABASE_MAP_INIT_CLASS_NAME, (Object)databaseMapInitClassName);
        String baseMapInitClassName = controllerState.getOption((OptionName)TemplateOptionName.OM_BASE_DATABASE_MAP_INIT_CLASS_NAME_PREFIX) + databaseMapInitClassName;
        sourceElement.setAttribute((SourceAttributeName)DatabaseAttributeName.BASE_DATABASE_MAP_INIT_CLASS_NAME, (Object)baseMapInitClassName);
    }

    private SourceElement getDatabaseSetWithDatabaseName(SourceElement databaseSetsElement, String name) {
        for (SourceElement databaseSetElement : databaseSetsElement.getChildren(DATABASE_SET_ELEMENT)) {
            if (!databaseSetElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME).equals(name)) continue;
            return databaseSetElement;
        }
        return null;
    }

    static {
        camelbacker.setDefaultLowerCase(false);
    }
}

