/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet.copy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.outlet.OutletImpl;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;

public class CopyOutlet
extends OutletImpl {
    private static Log log = LogFactory.getLog(CopyOutlet.class);
    private final String path;
    private final ConfigurationProvider configurationProvider;

    public CopyOutlet(QualifiedName name, ConfigurationProvider configurationProvider, String path) throws ConfigurationException {
        super(name);
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider is null");
        }
        this.path = path;
        this.configurationProvider = configurationProvider;
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start executing CopyOutlet " + this.getName()));
        }
        try {
            OutletResult result;
            InputStream inputStream = this.configurationProvider.getResourceInputStream(this.path);
            OutletResult outletResult = result = new OutletResult(IOUtils.toByteArray((InputStream)inputStream));
            return outletResult;
        }
        catch (IOException e) {
            throw new GeneratorException("CopyOutlet with name " + this.getName() + ": cannot read Resource " + this.path, e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End executing CopyOutlet " + this.getName()));
            }
        }
    }
}

