/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.system.oe.util.HandleCheckError;

public class OEChecks {
    private HandleCheckError errorHandler;
    private short scale = 1;
    private Connection conn = null;

    public void initialize(HandleCheckError errorHandler, Connection conn, short scale) throws Exception {
        this.errorHandler = errorHandler;
        this.conn = conn;
        conn.setAutoCommit(false);
        this.scale = scale;
    }

    public void checkAllRowCounts() throws Exception {
        this.testWarehouseRows();
        this.testStockRows();
        this.testItemRows();
        this.testCustomerRows();
        this.testDistrictRows();
        this.testOrdersRows();
        this.testNewOrdersRows();
        this.testOrderLineRows();
        this.testHistoryRows();
    }

    public void testWarehouseRows() throws Exception {
        this.checkCountStar("WAREHOUSE", this.scale);
    }

    public void testStockRows() throws Exception {
        this.checkCountStar("STOCK", 100000 * this.scale);
    }

    public void testOrdersRows() throws Exception {
        this.checkCountStar("ORDERS", 30000 * this.scale);
    }

    public void testDistrictRows() throws Exception {
        this.checkCountStar("DISTRICT", 10 * this.scale);
    }

    public void testCustomerRows() throws Exception {
        this.checkCountStar("CUSTOMER", 30000 * this.scale);
    }

    public void testItemRows() throws Exception {
        this.checkCountStar("ITEM", 100000);
    }

    public void testNewOrdersRows() throws Exception {
        this.checkCountStar("NEWORDERS", 9000 * this.scale);
    }

    public void testHistoryRows() throws Exception {
        this.checkCountStar("HISTORY", 30000 * this.scale);
    }

    public void testOrderLineRows() throws Exception {
        this.checkWithinOnePercent("ORDERLINE", 300000 * this.scale);
    }

    private void checkCountStar(String table, int expected) throws Exception {
        if (expected != this.rowsInTable(table)) {
            this.errorHandler.handleCheckError("ERROR:Number of rows loaded for " + table + " not correct, expected=" + expected + " rows found=" + this.rowsInTable(table));
        }
    }

    private int rowsInTable(String tableName) throws SQLException {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
        int count = rs.getInt(1);
        this.conn.commit();
        rs.close();
        stmt.close();
        return count;
    }

    private void checkWithinOnePercent(String tableName, int expected) throws Exception {
        double count = this.rowsInTable(tableName);
        double low = (double)expected * 0.99;
        double high = (double)expected * 1.01;
        if (count < low || count > high) {
            this.errorHandler.handleCheckError("ERROR! Initial rows" + count + " in " + tableName + " is out of range.[" + low + "-" + high + "]");
        }
    }
}

