/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ClientRunner;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TestPreInitSlave
extends ClientRunner {
    public TestPreInitSlave(String testcaseName) {
        super(testcaseName);
    }

    public static Test suite() throws Exception {
        System.out.println("**** TestPreInitSlave.suite()");
        TestPreInitSlave.initEnvironment();
        BaseTestSuite suite = new BaseTestSuite("TestPreInitSlave");
        suite.addTest(TestPreInitSlave.suite(slaveServerHost, slaveServerPort));
        System.out.println("*** Done suite.addTest(TestPreInitSlave.suite())");
        return suite;
    }

    public static Test suite(String serverHost, int serverPort) {
        System.out.println("*** TestPreInitSlave.suite(serverHost,serverPort)");
        Test t = TestConfiguration.existingServerSuite(TestPreInitSlave.class, false, serverHost, serverPort);
        System.out.println("*** Done TestConfiguration.existingServerSuite(TestPreInitSlave.class,false,serverHost,serverPort)");
        return t;
    }

    public void test() throws SQLException, IOException, InterruptedException {
        String msg;
        String ss;
        int ec;
        System.out.println("**** TestPreInitSlave.testStartSlaveConnect_OK() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName());
        String db = null;
        String connectionURL = null;
        Connection conn = null;
        db = masterDatabasePath + "/" + ReplicationRun.masterDbSubPath + "/" + replicatedDb;
        connectionURL = "jdbc:derby://" + masterServerHost + ":" + masterServerPort + "/" + db + ";stopMaster=true";
        System.out.println("1. " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("Unexpectedly connected: " + connectionURL);
            TestPreInitSlave.assertTrue((String)("Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            TestPreInitSlave.assertSQLState("stopMaster on master failed: " + connectionURL + " " + msg, "XRE07", se);
            System.out.println("stopMaster on master failed as expected: " + connectionURL + " " + msg);
        }
        db = slaveDatabasePath + "/" + ReplicationRun.slaveDbSubPath + "/" + replicatedDb;
        connectionURL = "jdbc:derby://" + slaveServerHost + ":" + slaveServerPort + "/" + db + ";stopSlave=true";
        System.out.println("2. " + connectionURL);
        try {
            conn = DriverManager.getConnection(connectionURL);
            System.out.println("Unexpectedly connected: " + connectionURL);
            TestPreInitSlave.assertTrue((String)("Unexpectedly connected: " + connectionURL), (boolean)false);
        }
        catch (SQLException se) {
            ec = se.getErrorCode();
            ss = se.getSQLState();
            msg = ec + " " + ss + " " + se.getMessage();
            TestPreInitSlave.assertSQLState("stopSlave on slave failed: " + connectionURL + " " + msg, "08004", se);
            System.out.println("stopSlave on slave failed as expected: " + connectionURL + " " + msg);
        }
    }

    public void verifyTestStartSlaveConnect_OK() throws SQLException, IOException, InterruptedException {
    }
}

