/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class ReplicationRun_Local_Encrypted_1
extends ReplicationRun {
    public ReplicationRun_Local_Encrypted_1(String testcaseName) {
        super(testcaseName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dataEncryption = "bootPassword=dilldall";
    }

    @Override
    protected void tearDown() throws Exception {
        dataEncryption = null;
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ReplicationRun_Local_Encrypted_1 Suite");
        suite.addTestSuite(ReplicationRun_Local_Encrypted_1.class);
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    public void testReplication_Encrypted_1_stdLoad() throws Exception {
        this.makeReadyForReplication();
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    public void testReplication_Encrypted_1_miniLoad_negative() throws Exception {
        this.makeReadyForReplication();
        String dbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        int tuplesToInsert = 10000;
        this._testInsertUpdateDeleteOnMaster(masterServerHost, masterServerPort, dbPath, tuplesToInsert);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        String slaveDbPath = slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb;
        this._verifyDatabase(slaveServerHost, slaveServerPort, slaveDbPath, tuplesToInsert);
        String masterDbPath = masterDatabasePath + FS + masterDbSubPath + FS + replicatedDb;
        this._verifyDatabase(masterServerHost, masterServerPort, masterDbPath, tuplesToInsert);
        dataEncryption = null;
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), null);
        dataEncryption = "bootPassword=;";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), null);
        dataEncryption = "bootPassword=dill2dall";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), null);
        this.shutdownDb(jvmVersion, slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath, replicatedDb, testClientHost);
        dataEncryption = null;
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), "XJ040");
        dataEncryption = "bootPassword=;";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), "XJ040");
        dataEncryption = "bootPassword=dill2dall";
        this.assertException(this._connectToSlave(slaveServerHost, slaveServerPort, slaveDbPath), "XJ040");
        dataEncryption = "bootPassword=dilldall";
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
    }

    SQLException _connectToSlave(String slaveServerHost, int slaveServerPort, String dbPath) throws Exception {
        ClientDataSourceInterface ds;
        this.util.DEBUG("_connectToSlave");
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            ds = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ds.setDatabaseName(dbPath);
        ds.setServerName(slaveServerHost);
        ds.setPortNumber(slaveServerPort);
        ds.setConnectionAttributes(this.useEncryption(false));
        try {
            Connection conn = ds.getConnection();
            conn.close();
            return null;
        }
        catch (SQLException se) {
            return se;
        }
    }
}

