/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RestrictedVTITest
extends GeneratedColumnsHelper {
    public RestrictedVTITest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(RestrictedVTITest.class);
        CleanDatabaseTestSetup result = new CleanDatabaseTestSetup((Test)suite);
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        if (!this.routineExists(conn, "GETLASTPROJECTION")) {
            this.goodStatement(conn, "create function getLastProjection\n()\nreturns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastProjection'\n");
        }
        if (!this.routineExists(conn, "GETLASTRESTRICTION")) {
            this.goodStatement(conn, "create function getLastRestriction\n()\nreturns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastRestriction'\n");
        }
        if (!this.routineExists(conn, "GETCOUNT")) {
            this.goodStatement(conn, "create function getCount\n()\nreturns int\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.IntegerArrayVTI.getLastQualifiedRowCount'\n");
        }
        if (!this.routineExists(conn, "INTEGERLIST")) {
            this.goodStatement(conn, "create function integerList()\nreturns table( s_r int, s_nr int, ns_r int, ns_nr int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        }
        if (!this.routineExists(conn, "NULLABLEINTEGERLIST")) {
            this.goodStatement(conn, "create function nullableIntegerList()\nreturns table( s_r int, s_nr int, ns_r int, ns_nr int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.nullableIntegerList'\n");
        }
        if (!this.routineExists(conn, "INTEGERLISTSPECIALCOLNAMES")) {
            this.goodStatement(conn, "create function integerListSpecialColNames()\nreturns table( \"CoL \"\"1\"\"\" int,\n\"cOL \"\"2\"\"\" int, col3 int, col4 int )\nlanguage java\nparameter style derby_jdbc_result_set\nno sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".integerListSpecialColNames'\n");
        }
        if (!this.routineExists(conn, "MAKEBLOB5370")) {
            this.goodStatement(conn, "create function makeBlob5370( ) returns blob\nlanguage java parameter style java no sql deterministic\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.BooleanValuesTest.makeSimpleBlob'\n");
        }
        if (!this.routineExists(conn, "LASTQUERY5370")) {
            this.goodStatement(conn, "create function lastQuery5370() returns varchar( 32672 )\nlanguage java parameter style java no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedTableVTI.getLastQuery'\n");
        }
        if (!this.routineExists(conn, "RESTRICTED5370")) {
            this.goodStatement(conn, "create function restricted5370( schemaName varchar( 32672 ), tableName varchar( 32672 ) )\nreturns table\n(\n    key_col int,\n    boolean_col  BOOLEAN,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB,\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2), \n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA\n)\nlanguage java parameter style derby_jdbc_result_set reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedTableVTI.readTable'\n");
        }
        if (!this.tableExists(conn, "T_4357_1")) {
            this.goodStatement(conn, "create table t_4357_1( a int )\n");
            this.goodStatement(conn, "insert into t_4357_1( a ) values cast( null as int), ( 1 ), ( 100 ), ( 1000 ), ( 10000)\n");
        }
        if (!this.tableExists(conn, "T_5370")) {
            this.goodStatement(conn, "create table t_5370\n(\n    key_col int,\n    boolean_col  BOOLEAN,\n    bigint_col  BIGINT,\n    blob_col  BLOB(2147483647),\n    char_col  CHAR(10),\n    char_for_bit_data_col  CHAR (10) FOR BIT DATA,\n    clob_col  CLOB,\n    date_col  DATE,\n    decimal_col  DECIMAL(5,2),\n    real_col  REAL,\n    double_col  DOUBLE,\n    int_col  INTEGER,\n    long_varchar_col  LONG VARCHAR,\n    long_varchar_for_bit_data_col  LONG VARCHAR FOR BIT DATA,\n    numeric_col  NUMERIC(5,2), \n    smallint_col  SMALLINT,\n    time_col  TIME,\n    timestamp_col  TIMESTAMP,\n    varchar_col  VARCHAR(10),\n    varchar_for_bit_data_col  VARCHAR (10) FOR BIT DATA\n)\n");
            this.goodStatement(conn, "insert into t_5370\n(\n    key_col,\n    boolean_col,\n    bigint_col,\n    blob_col,\n    char_col,\n    char_for_bit_data_col,\n    clob_col,\n    date_col,\n    decimal_col,\n    real_col,\n    double_col,\n    int_col,\n    long_varchar_col,\n    long_varchar_for_bit_data_col,\n    numeric_col, \n    smallint_col,\n    time_col,\n    timestamp_col,\n    varchar_col,\n    varchar_for_bit_data_col\n)\nvalues\n(\n    0,\n    false,\n    0,\n    makeBlob5370(),\n    '0',\n    X'DE',\n    '0',\n    date('1994-02-23'),\n    0.00,\n    0.0,\n    0.0,\n    0,\n    '0',\n    X'DE',\n    0.00, \n    0,\n    time('15:09:02'),\n    timestamp('1962-09-23 03:23:34.234'),\n    '0',\n    X'DE'\n),\n(\n    1,\n    true,\n    1,\n    makeBlob5370(),\n    '1',\n    X'DD',\n    '1',\n    date('1994-02-24'),\n    1.00,\n    1.0,\n    1.0,\n    1,\n    '1',\n    X'DE',\n    1.00, \n    1,\n    time('15:09:03'),\n    timestamp('1963-09-23 03:23:34.234'),\n    '1',\n    X'DD'\n),\n(\n    2,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null,\n    null\n)\n");
        }
    }

    public void test_01_heartbeat() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000 order by s_r\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null);
        PreparedStatement ps = this.chattyPrepare(conn, "select s_r from table( integerList() ) s where s_r > 1 and ns_r < ?");
        ps.setInt(1, 30000);
        ResultSet rs = ps.executeQuery();
        this.assertResults(rs, new String[][]{{"100"}, {"1000"}}, false);
        this.assertResults(conn, "values ( getLastProjection() )\n", new String[][]{{"[S_R, null, NS_R, null]"}}, false);
        this.assertResults(conn, "values ( getLastRestriction() )\n", new String[][]{{"( \"NS_R\" < 30000 ) AND ( \"S_R\" > 1 )"}}, false);
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where not( s_r > 1 and ns_r < 3000 )\n", new String[][]{{"1", "2"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "( \"S_R\" <= 1 ) OR ( \"NS_R\" >= 3000 )");
    }

    public void test_02_aliasing() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select 2*w, x from table( integerList() ) as s( w, x, y, z ) where w > 1 and mod( y, 3 ) = 0\n", new String[][]{{"200", "200"}, {"2000", "2000"}, {"20000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"S_R\" > 1");
    }

    public void test_03_allRelationalOperators() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r is null\n", new String[][]{{null, "2"}}, "[S_R, S_NR, null, null]", "\"S_R\" IS NULL ");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r is not null\n", new String[][]{{"100", null}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" IS NOT NULL ");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r < 1000\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" < 1000");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r <= 100\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" <= 100");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r = 100\n", new String[][]{{"100", null}}, "[S_R, S_NR, null, null]", "\"S_R\" = 100");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r > 100\n", new String[][]{{"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r >= 100\n", new String[][]{{"100", null}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" >= 100");
    }

    public void test_04_misc() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select s_r, s_nr from table( nullableIntegerList() ) s where s_r < s_nr + ns_r\n", new String[][]{{"10000", "20000"}}, "[S_R, S_NR, NS_R, null]", null);
        this.assertPR(conn, "select s_r from table( nullableIntegerList() ) s where ns_r = cast( '300' as int)\n", new String[][]{{"100"}}, "[S_R, null, NS_R, null]", "\"NS_R\" = 300");
    }

    public void test_05_joins() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select a, w, y from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w\n", new String[][]{{"100", "100", "300"}, {"1000", "1000", null}, {"10000", "10000", "30000"}}, "[S_R, null, NS_R, null]", null);
        this.assertPR(conn, "select a, w, y from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w order by y\n", new String[][]{{"100", "100", "300"}, {"10000", "10000", "30000"}, {"1000", "1000", null}}, "[S_R, null, NS_R, null]", null);
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and y is not null\n", new String[][]{{"100", "100", null}, {"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"NS_R\" IS NOT NULL ");
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and y is not null order by w\n", new String[][]{{"100", "100", null}, {"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", "\"NS_R\" IS NOT NULL ");
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a > 100\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a > 100 order by x\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 100");
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and a + x > 100\n", new String[][]{{"1000", "1000", "2000"}, {"10000", "10000", "20000"}}, "[S_R, S_NR, null, null]", null);
        this.assertPR(conn, "select a, w, x from t_4357_1, table( nullableIntegerList() ) as s( w, x, y, z ) where a = w and x + y > 100\n", new String[][]{{"10000", "10000", "20000"}}, "[S_R, S_NR, NS_R, null]", null);
    }

    public void test_06_distinct() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select distinct s_r, s_nr from table( integerList() ) s where s_r > 1 and ns_r < 3000\n", new String[][]{{"100", "200"}}, "[S_R, S_NR, NS_R, null]", "( \"NS_R\" < 3000 ) AND ( \"S_R\" > 1 )");
        this.assertPR(conn, "select distinct s_r, s_nr from table( integerList() ) s\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null);
    }

    public void test_07_subqueries() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select * from t_4357_1 where exists ( select x from table( nullableIntegerList() ) as s( w, x, y, z ) where a = w )\n", new String[][]{{"100"}, {"1000"}, {"10000"}}, "[S_R, S_NR, null, null]", null);
        this.assertPR(conn, "select * from table( nullableIntegerList() ) as t( a, b, c, d ) where exists ( select x from table( nullableIntegerList() ) as s( w, x, y, z ) where a = w )\n", new String[][]{{"100", null, "300", "400"}, {"1000", "2000", null, "4000"}, {"10000", "20000", "30000", null}}, "[S_R, S_NR, null, null]", null);
    }

    public void test_08_having() throws Exception {
        this.assertPR(this.getConnection(), "select s_r, count(*) from table(integerList()) t group by s_r having s_r > 1", new String[][]{{"100", "1"}, {"1000", "1"}, {"10000", "1"}}, "[S_R, null, null, null]", null);
    }

    public void test_09_4651() throws Exception {
        Connection conn = this.getConnection();
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null, 4);
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where s_r > 500 order by s_r\n", new String[][]{{"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", "\"S_R\" > 500", 2);
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where s_r > 500 or 1=1 order by s_r\n", new String[][]{{"1", "2"}, {"100", "200"}, {"1000", "2000"}, {"10000", "20000"}}, "[S_R, S_NR, null, null]", null, 4);
        this.assertPR(conn, "select s_r, s_nr from table( integerList() ) s where s_r > 500 and 1 != 1 order by s_r\n", new String[0][], "[S_R, S_NR, null, null]", null, 4);
    }

    public void test_10_quotes_in_column_names() throws Exception {
        String[][] expectedRows = new String[][]{{"100", "200", "300", "400"}};
        String expectedRestriction = "( \"cOL \"\"2\"\"\" < 1000 ) AND ( \"CoL \"\"1\"\"\" > 1 )";
        this.assertPR(this.getConnection(), "select * from table(integerListSpecialColNames()) t where \"CoL \"\"1\"\"\" > 1 and \"cOL \"\"2\"\"\" < 1000", expectedRows, "[CoL \"1\", cOL \"2\", COL3, COL4]", expectedRestriction);
        Statement stmt = this.createStatement();
        ResultSet rs = RestrictedVTITest.executeQuery(stmt, "values getLastRestriction()");
        RestrictedVTITest.assertTrue((String)"empty result", (boolean)rs.next());
        String restriction = rs.getString(1);
        RestrictedVTITest.assertEquals((String)expectedRestriction, (String)restriction);
        rs.close();
        rs = RestrictedVTITest.executeQuery(stmt, "select * from table(integerListSpecialColNames()) t where " + restriction);
        JDBC.assertUnorderedResultSet(rs, expectedRows);
    }

    public void test_11_5369_5370() throws Exception {
        Connection conn = this.getConnection();
        if (JDBC.vmSupportsJSR169()) {
            return;
        }
        this.vetDatatypeCount(conn, 22);
        this.vet5370positive(conn, "BOOLEAN_COL", "false", "false", "true");
        this.vet5370positive(conn, "BIGINT_COL", "0", "0", "1");
        this.vet5370positive(conn, "CHAR_COL", "'0'", "0         ", "1         ");
        this.vet5370positive(conn, "CHAR_FOR_BIT_DATA_COL", "X'de'", "de202020202020202020", "dd202020202020202020");
        this.vet5370positive(conn, "DATE_COL", "DATE('1994-02-23')", "1994-02-23", "1994-02-24");
        this.vet5370positive(conn, "DECIMAL_COL", "0.00", "0.00", "1.00");
        this.vet5370positive(conn, "REAL_COL", "0.0", "0.0", "1.0");
        this.vet5370positive(conn, "DOUBLE_COL", "0.0", "0.0", "1.0");
        this.vet5370positive(conn, "INT_COL", "0", "0", "1");
        this.vet5370positive(conn, "NUMERIC_COL", "0.00", "0.00", "1.00");
        this.vet5370positive(conn, "SMALLINT_COL", "0", "0", "1");
        this.vet5370positive(conn, "TIME_COL", "TIME('15:09:02')", "15:09:02", "15:09:03");
        this.vet5370positive(conn, "TIMESTAMP_COL", "TIMESTAMP('1962-09-23 03:23:34.234')", "1962-09-23 03:23:34.234", "1963-09-23 03:23:34.234");
        this.vet5370positive(conn, "VARCHAR_COL", "'0'", "0", "1");
        this.vet5370positive(conn, "VARCHAR_FOR_BIT_DATA_COL", "X'de'", "de", "dd");
        this.vet5370negative("BLOB_COL", "makeBlob5370()");
        this.vet5370negative("CLOB_COL", "'0'");
        this.vet5370negative("LONG_VARCHAR_COL", "'0'");
        this.vet5370negative("LONG_VARCHAR_FOR_BIT_DATA_COL", "X'de'");
    }

    private void vet5370positive(Connection conn, String columnName, String columnValue, String expectedValue, String negatedValue) throws Exception {
        this.assertResults(conn, "select " + columnName + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + columnName + " = " + columnValue, new String[][]{{expectedValue}}, false);
        this.assertResults(conn, "values( lastQuery5370() )", new String[][]{{"select " + RestrictedVTITest.doubleQuote(columnName) + "\nfrom " + RestrictedVTITest.doubleQuote("APP") + "." + RestrictedVTITest.doubleQuote("T_5370") + "\nwhere " + RestrictedVTITest.doubleQuote(columnName) + " = " + columnValue}}, false);
        this.assertResults(conn, "select " + columnName + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + columnName + " != " + columnValue, new String[][]{{negatedValue}}, false);
        this.assertResults(conn, "values( lastQuery5370() )", new String[][]{{"select " + RestrictedVTITest.doubleQuote(columnName) + "\nfrom " + RestrictedVTITest.doubleQuote("APP") + "." + RestrictedVTITest.doubleQuote("T_5370") + "\nwhere " + RestrictedVTITest.doubleQuote(columnName) + " != " + columnValue}}, false);
    }

    private static String doubleQuote(String text) {
        return "\"" + text + "\"";
    }

    private void vet5370negative(String columnName, String columnValue) throws Exception {
        this.expectCompilationError("42818", "select " + columnName + " from table( restricted5370( 'APP', 'T_5370' ) ) s\nwhere " + columnName + " = " + columnValue);
    }

    private int vetDatatypeCount(Connection conn, int expectedTypeCount) throws Exception {
        ResultSet rs = conn.getMetaData().getTypeInfo();
        int actualTypeCount = 0;
        while (rs.next()) {
            ++actualTypeCount;
        }
        rs.close();
        RestrictedVTITest.assertEquals((int)expectedTypeCount, (int)actualTypeCount);
        return actualTypeCount;
    }

    public void test_12_6036() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "create view v6036 as select * from table( integerList() ) s");
        this.assertResults(conn, "select s_nr from table( integerList() ) s where ns_r = 3000", new String[][]{{"2000"}}, false);
        this.assertResults(conn, "values getLastProjection()", new String[][]{{"[null, S_NR, NS_R, null]"}}, false);
        this.assertResults(conn, "values getLastRestriction()", new String[][]{{"\"NS_R\" = 3000"}}, false);
        this.assertResults(conn, "select s_nr from v6036 where ns_r = 3000", new String[][]{{"2000"}}, false);
        this.assertResults(conn, "values getLastProjection()", new String[][]{{"[S_R, S_NR, NS_R, NS_NR]"}}, false);
        this.assertResults(conn, "values getLastRestriction()", new String[][]{{"\"NS_R\" = 3000"}}, false);
    }

    public static IntegerArrayVTI integerList() {
        return new IntegerArrayVTI(new String[]{"S_R", "S_NR", "NS_R", "NS_NR"}, (int[][])new int[][]{{1, 2, 3, 4}, {100, 200, 300, 400}, {1000, 2000, 3000, 4000}, {10000, 20000, 30000, 40000}});
    }

    public static IntegerArrayVTI nullableIntegerList() {
        return new IntegerArrayVTI(new String[]{"S_R", "S_NR", "NS_R", "NS_NR"}, (Integer[][])new Integer[][]{{null, RestrictedVTITest.i(2), RestrictedVTITest.i(3), RestrictedVTITest.i(4)}, {RestrictedVTITest.i(100), null, RestrictedVTITest.i(300), RestrictedVTITest.i(400)}, {RestrictedVTITest.i(1000), RestrictedVTITest.i(2000), null, RestrictedVTITest.i(4000)}, {RestrictedVTITest.i(10000), RestrictedVTITest.i(20000), RestrictedVTITest.i(30000), null}});
    }

    private static Integer i(int intValue) {
        return intValue;
    }

    public static IntegerArrayVTI integerListSpecialColNames() {
        return new IntegerArrayVTI(new String[]{"CoL \"1\"", "cOL \"2\"", "COL3", "COL4"}, (int[][])new int[][]{{1, 2, 3, 4}, {100, 200, 300, 400}, {1000, 2000, 3000, 4000}, {10000, 20000, 30000, 40000}});
    }

    private boolean routineExists(Connection conn, String functionName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.sysaliases where alias = ?");
        ps.setString(1, functionName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }

    private boolean tableExists(Connection conn, String tableName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.systables where tablename = ?");
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }

    private void assertPR(Connection conn, String query, String[][] expectedResults, String expectedProjection, String expectedRestriction, int expectedQualifiedRowCount) throws Exception {
        this.assertPR(conn, query, expectedResults, expectedProjection, expectedRestriction);
        this.assertResults(conn, "values ( getCount() )\n", new String[][]{{Integer.toString(expectedQualifiedRowCount)}}, false);
    }

    private void assertPR(Connection conn, String query, String[][] expectedResults, String expectedProjection, String expectedRestriction) throws Exception {
        this.assertResults(conn, query, expectedResults, false);
        this.assertResults(conn, "values ( getLastProjection() )\n", new String[][]{{expectedProjection}}, false);
        this.assertResults(conn, "values ( getLastRestriction() )\n", new String[][]{{expectedRestriction}}, false);
    }
}

