/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class DropTableTest
extends BaseJDBCTestCase {
    public DropTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(DropTableTest.class);
    }

    public void testDropTableWithConstraints() throws Exception {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1 ( a int)");
        st.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("create table t1 (a int not null unique)");
        st.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("create table t1 ( a int not null primary key)");
        st.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("create table t1 ( a int check(a > 0))");
        st.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("create table t1 ( a int)");
        st.executeUpdate(" create index t1index on t1(a)");
        st.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("create table t1(a int not null primary key)");
        st.executeUpdate(" create table t2(a int constraint reft1a references t1(a))");
        DropTableTest.assertStatementError("X0Y25", st, "drop table t1");
        st.executeUpdate("alter table t2 drop constraint reft1a");
        st.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate("insert into t2 values(1)");
        st.executeUpdate(" drop table t2");
    }

    public void testDropTableWithView() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1(a int, b int)");
        st.executeUpdate(" create table t2(c int, d int)");
        st.executeUpdate(" create view vt1a as select a from t1");
        st.executeUpdate(" create view vt1b as select b from t1");
        st.executeUpdate(" create view vt1t2 as select * from t1, t2");
        st.executeUpdate(" create view vvt1a as select * from vt1a");
        st.executeUpdate(" create view vvvt1a as select * from vvt1a");
        DropTableTest.assertStatementError("X0Y23", st, "drop table t1");
        st.executeUpdate("drop view vvvt1a");
        st.executeUpdate(" drop view vvt1a");
        st.executeUpdate(" drop view vt1t2");
        st.executeUpdate(" drop view vt1b");
        st.executeUpdate(" drop view vt1a");
        st.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from vt1a");
        DropTableTest.assertStatementError("42X05", st, " select * from vt1b");
        DropTableTest.assertStatementError("42X05", st, " select * from vt1t2");
        DropTableTest.assertStatementError("42X05", st, " select * from vvt1a");
        DropTableTest.assertStatementError("42X05", st, " select * from vvvt1a");
        st.executeUpdate(" drop table t2");
    }

    public void testDropTableWithPreparedStatement() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1(a int)");
        PreparedStatement pSt = this.prepareStatement("select * from t1");
        st.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", pSt);
    }

    public void testDropTableWithTriggers() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1(a int)");
        st.executeUpdate(" create table t2(a int)");
        st.executeUpdate(" create trigger t1trig after insert on t1 for each row insert into t2 values(1)");
        st.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", st, "select * from t1");
        st.executeUpdate(" drop table t2");
        st.executeUpdate("create table t1(a int)");
        st.executeUpdate(" create table t2(a int)");
        st.executeUpdate(" create trigger t2trig after insert on t2 for each row insert into t1 values(1)");
        DropTableTest.assertStatementError("X0Y25", st, "drop table t1");
        st.executeUpdate("insert into t2 values(1)");
        JDBC.assertSingleValueResultSet(st.executeQuery("select * from t1"), "1");
        JDBC.assertSingleValueResultSet(st.executeQuery("select * from t2"), "1");
        st.executeUpdate(" drop table t2");
        st.executeUpdate(" drop table t1");
    }

    public void testDropTableDropView() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t1(a int)");
        st.executeUpdate(" create view vt1 as select * from t1");
        st.executeUpdate(" create view vvt1 as select * from vt1");
        DropTableTest.assertStatementError("X0Y23", st, "drop view vt1");
        DropTableTest.assertStatementError("42X01", st, " drop view vt1 restrict");
        DropTableTest.assertStatementError("42X01", st, " drop view vt1 cascade");
        st.executeUpdate("drop view vvt1");
        st.executeUpdate("drop view  vt1");
        st.executeUpdate("drop table  t1");
    }

    public void testDropTableIndexesDropped() throws SQLException {
        Statement st = this.createStatement();
        this.setAutoCommit(false);
        st.executeUpdate("create table t2(a int not null primary key)");
        st.executeUpdate("create table reft2(a int constraint ref1 references t2)");
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from (sys.sysconglomerates c), (sys.systables t) where t.tableid = c.tableid and t.tablename = 'REFT2'"), "2");
        st.executeUpdate("alter table reft2 drop constraint ref1");
        st.executeUpdate("drop table t2");
        JDBC.assertSingleValueResultSet(st.executeQuery("select count(*) from (sys.sysconglomerates c), (sys.systables t) where t.tableid = c.tableid and t.tablename = 'REFT2'"), "1");
        this.rollback();
        st.executeUpdate(" create table T1 (i int, c varchar(255), d varchar(255))");
        st.executeUpdate(" insert into T1(i) values(1)");
        st.executeUpdate(" insert into T1(i) values(2)");
        Statement st1 = this.createStatement();
        st1.setCursorName("X1");
        ResultSet rs1 = st1.executeQuery("select i from t1 for update of c");
        PreparedStatement pSt = this.prepareStatement("update t1 set c = CHAR(i) where current of X1");
        DropTableTest.assertStatementError("X0X95", st, "drop table T1");
        rs1.next();
        pSt.executeUpdate();
        ResultSet rs = st.executeQuery("select * from T1");
        String[] expColNames = new String[]{"I", "C", "D"};
        JDBC.assertColumnNames(rs, expColNames);
        String[][] expRS = new String[][]{{"1", "1", null}, {"2", null, null}};
        JDBC.assertFullResultSet(rs, expRS);
        st1.close();
        st.executeUpdate("drop table T1");
        this.setAutoCommit(true);
    }
}

