/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LobRsGetterTest
extends BaseJDBCTestCase {
    private static final String TABLE = "LOB_RS_GETTER_TEST";
    private static final boolean UNSUPPORTED = false;
    private static final boolean SUPPORTED = true;
    private static final int BLOB = 0;
    private static final int CLOB = 1;
    private static final int GET_BYTES = 0;
    private static final int GET_STRING = 1;
    private static final int GET_ASCII_STREAM = 2;
    private static final int GET_BINARY_STREAM = 3;
    private static final int GET_CHARACTER_STREAM = 4;
    private static final int GET_CLOB = 5;
    private static final int GET_BLOB = 6;
    private static final int GET_OBJECT = 7;
    private static final boolean X = true;
    private static final boolean E = true;
    private static final boolean u = false;
    private static final boolean[][] COMPATIBLE_GETTERS = new boolean[][]{{true, false}, {true, true}, {true, true}, {true, false}, {true, true}, {false, true}, {true, false}, {true, true}};
    private static final String[] GETTER_NAMES = new String[]{"getBytes", "getString", "getAsciiStream", "getBinaryStream", "getCharacterStream", "getClob", "getBlob", "getObject"};

    public LobRsGetterTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = TestConfiguration.defaultSuite(LobRsGetterTest.class, false);
        return new CleanDatabaseTestSetup(suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Connection con = s.getConnection();
                BaseJDBCTestCase.dropTable(con, LobRsGetterTest.TABLE);
                s.executeUpdate("create table LOB_RS_GETTER_TEST(id INT GENERATED ALWAYS AS IDENTITY, dBlob BLOB, dClob CLOB)");
                PreparedStatement ps = con.prepareStatement("insert into LOB_RS_GETTER_TEST(dBlob, dClob) values (?,?)");
                int mpSize = 177152;
                int spSize = 300;
                ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(mpSize), mpSize);
                ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(mpSize), mpSize);
                ps.executeUpdate();
                ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(spSize), spSize);
                ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(spSize), spSize);
                ps.executeUpdate();
                ps.setNull(1, 2004);
                ps.setNull(2, 2005);
                ps.executeUpdate();
                JDBC.assertDrainResults(s.executeQuery("select * from LOB_RS_GETTER_TEST"), 3);
                ps.close();
                s.close();
            }
        };
    }

    public void testBlobGettersSimple() throws SQLException {
        this._testGettersSimple("dBlob", 0);
    }

    public void testClobGettersSimple() throws SQLException {
        this._testGettersSimple("dClob", 1);
    }

    public void testBlobGettersSimpleNegative() throws SQLException {
        this._testGettersSimpleNegative("dBlob", 0);
    }

    public void testClobGettersSimpleNegative() throws SQLException {
        this._testGettersSimpleNegative("dClob", 1);
    }

    public void testBlobGettersMultiInvocation() throws SQLException {
        this._testGettersMultiInvocation("dBlob", 0);
    }

    public void testClobGettersMultiInvocation() throws SQLException {
        this._testGettersMultiInvocation("dClob", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlobGetXFollowedByGetBytes() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dBlob from LOB_RS_GETTER_TEST");
        for (int getter = 0; getter < COMPATIBLE_GETTERS.length; ++getter) {
            if (!COMPATIBLE_GETTERS[getter][0]) continue;
            ResultSet rs = ps.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs.next());
            this.invokeGetter(rs, 0, getter);
            try {
                this.invokeGetter(rs, 0, 0);
                LobRsGetterTest.assertTrue((String)("getBytes should have failed after: " + this.debugInfo(1, rs, 0, getter)), (getter == 0 || getter == 1 ? 1 : 0) != 0);
                continue;
            }
            catch (SQLException sqle) {
                LobRsGetterTest.assertTrue((getter != 0 ? 1 : 0) != 0);
                LobRsGetterTest.assertSQLState(this.debugInfo(1, rs, 0, getter) + " followed by getBytes", "XCL18", sqle);
                continue;
            }
            finally {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClobGetXFollowedByGetString() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select dClob from LOB_RS_GETTER_TEST");
        for (int getter = 0; getter < COMPATIBLE_GETTERS.length; ++getter) {
            if (!COMPATIBLE_GETTERS[getter][1]) continue;
            ResultSet rs = ps.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs.next());
            this.invokeGetter(rs, 1, getter);
            try {
                this.invokeGetter(rs, 1, 1);
                LobRsGetterTest.assertTrue((String)("getString should have failed after: " + this.debugInfo(1, rs, 1, getter)), (getter == 1 ? 1 : 0) != 0);
                continue;
            }
            catch (SQLException sqle) {
                LobRsGetterTest.assertTrue((getter != 1 ? 1 : 0) != 0);
                LobRsGetterTest.assertSQLState(this.debugInfo(1, rs, 1, getter) + " followed by getString", "XCL18", sqle);
                continue;
            }
            finally {
                rs.close();
            }
        }
    }

    public void testCorrectBlobDataWithMultiCall() throws IOException, SQLException {
        this.setAutoCommit(false);
        PreparedStatement psId = this.prepareStatement("select id from LOB_RS_GETTER_TEST");
        String select = "select dBlob from LOB_RS_GETTER_TEST where id = ?";
        PreparedStatement ps1 = this.prepareStatement(select);
        PreparedStatement ps2 = this.prepareStatement(select);
        ResultSet rsId = psId.executeQuery();
        while (rsId.next()) {
            ps1.setInt(1, rsId.getInt(1));
            ps2.setInt(1, rsId.getInt(1));
            ResultSet rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getBytes(1);
            rs1.getString(1);
            ResultSet rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getBinaryStream(1), rs1.getBinaryStream(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs1.getBytes(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getBlob(1), rs1.getBlob(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getBytes(1);
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getCharacterStream(1), rs1.getCharacterStream(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getBytes(1);
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertTrue((boolean)Arrays.equals(rs2.getBytes(1), rs1.getBytes(1)));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getBytes(1);
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals((String)rs2.getString(1), (String)rs1.getString(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs1.getBytes(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            Blob b1 = (Blob)rs1.getObject(1);
            Blob b2 = (Blob)rs2.getObject(1);
            LobRsGetterTest.assertEquals(b2, b1);
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getBytes(1);
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getAsciiStream(1), rs1.getAsciiStream(1));
            rs1.close();
            rs2.close();
        }
        this.rollback();
    }

    public void testCorrectClobDataWithMultiCall() throws IOException, SQLException {
        this.setAutoCommit(false);
        PreparedStatement psId = this.prepareStatement("select id, dClob from LOB_RS_GETTER_TEST");
        String select = "select dClob from LOB_RS_GETTER_TEST where id = ?";
        PreparedStatement ps1 = this.prepareStatement(select);
        PreparedStatement ps2 = this.prepareStatement(select);
        ResultSet rsId = psId.executeQuery();
        while (rsId.next()) {
            ps1.setInt(1, rsId.getInt(1));
            ps2.setInt(1, rsId.getInt(1));
            ResultSet rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            ResultSet rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals((String)rs2.getString(1), (String)rs1.getString(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getCharacterStream(1), rs1.getCharacterStream(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getClob(1), rs1.getClob(1));
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            Clob b1 = (Clob)rs1.getObject(1);
            Clob b2 = (Clob)rs2.getObject(1);
            LobRsGetterTest.assertEquals(b2, b1);
            rs1.close();
            rs2.close();
            rs1 = ps1.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs1.next());
            rs1.getString(1);
            rs2 = ps2.executeQuery();
            LobRsGetterTest.assertTrue((boolean)rs2.next());
            LobRsGetterTest.assertEquals(rs2.getAsciiStream(1), rs1.getAsciiStream(1));
            rs1.close();
            rs2.close();
        }
        this.rollback();
    }

    private void _testGettersMultiInvocation(String columnName, int typeIdx) throws SQLException {
        PreparedStatement ps = this.prepareStatement("select " + columnName + " from LOB_RS_GETTER_TEST");
        for (int getter = 0; getter < COMPATIBLE_GETTERS.length; ++getter) {
            boolean supported = COMPATIBLE_GETTERS[getter][typeIdx];
            if (!supported) continue;
            ResultSet rs = ps.executeQuery();
            rs.next();
            this.invokeGetter(rs, typeIdx, getter);
            try {
                this.invokeGetter(rs, typeIdx, getter);
                if (getter == 0 || getter == 1) continue;
                LobRsGetterTest.fail((String)("calling the getter twice should have failed: " + GETTER_NAMES[getter] + " on " + this.typeName(typeIdx)));
                continue;
            }
            catch (SQLException sqle) {
                LobRsGetterTest.assertSQLState("XCL18", sqle);
            }
        }
    }

    private void _testGettersSimpleNegative(String columnName, int typeIdx) throws SQLException {
        PreparedStatement ps = this.prepareStatement("select " + columnName + " from LOB_RS_GETTER_TEST");
        for (int getter = 0; getter < COMPATIBLE_GETTERS.length; ++getter) {
            boolean supported = COMPATIBLE_GETTERS[getter][typeIdx];
            if (supported) continue;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                try {
                    this.invokeGetter(rs, typeIdx, getter);
                    if (rs.wasNull()) continue;
                    LobRsGetterTest.fail((String)("expected getter to fail on non-NULL value: " + this.debugInfo(1, rs, typeIdx, getter)));
                }
                catch (SQLException sqle) {
                    LobRsGetterTest.assertSQLState("22005", sqle);
                }
            }
            rs.close();
        }
    }

    private void _testGettersSimple(String columnName, int typeIdx) throws SQLException {
        PreparedStatement ps = this.prepareStatement("select " + columnName + " from LOB_RS_GETTER_TEST");
        for (int getter = 0; getter < COMPATIBLE_GETTERS.length; ++getter) {
            boolean supported = COMPATIBLE_GETTERS[getter][typeIdx];
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                try {
                    this.invokeGetter(rs, typeIdx, getter);
                    if (supported) continue;
                    LobRsGetterTest.assertTrue((String)("should not have worked: " + this.debugInfo(1, rs, typeIdx, getter)), (boolean)rs.wasNull());
                }
                catch (SQLException sqle) {
                    if (!supported) {
                        LobRsGetterTest.assertSQLState("22005", sqle);
                        continue;
                    }
                    throw sqle;
                }
            }
            rs.close();
        }
        ps.close();
    }

    private void invokeGetter(ResultSet rs, int typeIdx, int getter) throws SQLException {
        this.invokeGetter(1, rs, typeIdx, getter);
    }

    private void invokeGetter(int column, ResultSet rs, int typeIdx, int getter) throws SQLException {
        Object ret;
        LobRsGetterTest.println("invoking " + this.debugInfo(column, rs, typeIdx, getter));
        switch (getter) {
            case 0: {
                ret = rs.getBytes(column);
                break;
            }
            case 1: {
                ret = rs.getString(column);
                break;
            }
            case 2: {
                ret = rs.getAsciiStream(column);
                break;
            }
            case 3: {
                ret = rs.getBinaryStream(column);
                break;
            }
            case 4: {
                ret = rs.getCharacterStream(column);
                break;
            }
            case 5: {
                ret = rs.getClob(column);
                break;
            }
            case 6: {
                ret = rs.getBlob(column);
                break;
            }
            case 7: {
                ret = rs.getObject(column);
                break;
            }
            default: {
                LobRsGetterTest.fail((String)("unsupported getter index: " + getter));
                throw new IllegalStateException();
            }
        }
        if (rs.wasNull()) {
            LobRsGetterTest.assertNull((Object)ret);
        } else {
            LobRsGetterTest.assertNotNull((Object)ret);
        }
    }

    private String typeName(int typeIdx) {
        switch (typeIdx) {
            case 0: {
                return "BLOB";
            }
            case 1: {
                return "CLOB";
            }
        }
        return "UNKNOWN";
    }

    private String debugInfo(int colIdx, ResultSet rs, int typeIdx, int getter) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        return GETTER_NAMES[getter] + " on " + this.typeName(typeIdx) + " (meta:col=" + colIdx + ",type=" + meta.getColumnTypeName(colIdx) + ",name=" + meta.getColumnName(colIdx) + ")";
    }
}

