/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ExceptionUtil {
    public static String getSQLStateFromIdentifier(String messageID) {
        if (messageID.length() == 5) {
            return messageID;
        }
        return messageID.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String messageID) {
        int lseverity = 0;
        block0 : switch (messageID.length()) {
            case 5: {
                block3 : switch (messageID.charAt(0)) {
                    case '0': {
                        switch (messageID.charAt(1)) {
                            case '1': {
                                lseverity = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                lseverity = 20000;
                                break;
                            }
                            case '8': {
                                lseverity = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        lseverity = 20000;
                        break;
                    }
                    case '4': {
                        switch (messageID.charAt(1)) {
                            case '0': {
                                lseverity = 30000;
                                break block3;
                            }
                            case '2': {
                                lseverity = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (messageID.charAt(6)) {
                    case 'M': {
                        lseverity = 50000;
                        break block0;
                    }
                    case 'D': {
                        lseverity = 45000;
                        break block0;
                    }
                    case 'C': {
                        lseverity = 40000;
                        break block0;
                    }
                    case 'T': {
                        lseverity = 30000;
                        break block0;
                    }
                    case 'S': {
                        lseverity = 20000;
                        break block0;
                    }
                    case 'U': {
                        lseverity = 0;
                    }
                }
            }
        }
        return lseverity;
    }

    public static String dumpThreads() {
        StringWriter out = new StringWriter();
        PrintWriter p = new PrintWriter((Writer)out, true);
        try {
            Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Class<?> c = Class.forName("org.apache.derby.shared.common.sanity.ThreadDump");
            final Method m = c.getMethod("getStackDumpString", new Class[0]);
            String dump = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    return m.invoke(null, (Object[])null);
                }
            });
            p.print("---------------\nStack traces for all live threads:");
            p.println("\n" + dump);
            p.println("---------------");
        }
        catch (NoSuchMethodException e) {
            p.println("(Skipping thread dump because it is not supported on JVM 1.4)");
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException && e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof AccessControlException) {
                p.println("(Skipping thread dump because of insufficient permissions:\n" + e.getCause().getCause() + ")\n");
            }
            p.println("\nAssertFailure tried to do a thread dump, but there was an error:");
            e.getCause().printStackTrace(p);
        }
        return out.toString();
    }

    public static boolean isDeferredConstraintViolation(String e) {
        return e.equals(ExceptionUtil.getSQLStateFromIdentifier("23506.T.1")) || e.equals(ExceptionUtil.getSQLStateFromIdentifier("23514.T.1"));
    }
}

