/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.derby.shared.common.drda.NaiveTrustManager;

class OpenSocketAction
implements PrivilegedExceptionAction<Socket> {
    private String server_;
    private int port_;
    private int clientSSLMode_;

    OpenSocketAction(String server, int port, int clientSSLMode) {
        this.server_ = server;
        this.port_ = port;
        this.clientSSLMode_ = clientSSLMode;
    }

    @Override
    public Socket run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        SocketFactory sf;
        switch (this.clientSSLMode_) {
            case 1: {
                Properties sslProperties = this.getSSLProperties();
                sf = NaiveTrustManager.getSocketFactory(sslProperties);
                break;
            }
            case 2: {
                sf = SSLSocketFactory.getDefault();
                break;
            }
            case 0: {
                sf = SocketFactory.getDefault();
                break;
            }
            default: {
                sf = SocketFactory.getDefault();
            }
        }
        if (this.clientSSLMode_ == 1 || this.clientSSLMode_ == 2) {
            SSLSocket sSocket = (SSLSocket)sf.createSocket(this.server_, this.port_);
            String[] enabledProtocols = sSocket.getEnabledProtocols();
            String[] supportedProtocols = new String[enabledProtocols.length];
            int supportedProtocolsCount = 0;
            for (int i = 0; i < enabledProtocols.length; ++i) {
                if (enabledProtocols[i].toUpperCase().contains("SSLV3") || enabledProtocols[i].toUpperCase().contains("SSLV2HELLO")) continue;
                supportedProtocols[supportedProtocolsCount] = enabledProtocols[i];
                ++supportedProtocolsCount;
            }
            if (supportedProtocolsCount < enabledProtocols.length) {
                String[] newEnabledProtocolsList = null;
                newEnabledProtocolsList = new String[supportedProtocolsCount];
                System.arraycopy(supportedProtocols, 0, newEnabledProtocolsList, 0, supportedProtocolsCount);
                sSocket.setEnabledProtocols(newEnabledProtocolsList);
            }
            return sSocket;
        }
        return sf.createSocket(this.server_, this.port_);
    }

    private Properties getSSLProperties() {
        Properties retval = new Properties();
        String keyStoreProp = System.getProperty("javax.net.ssl.keyStore");
        if (keyStoreProp != null) {
            retval.setProperty("javax.net.ssl.keyStore", keyStoreProp);
        }
        String keyStorePasswordProp = System.getProperty("javax.net.ssl.keyStorePassword");
        if (keyStoreProp != null) {
            retval.setProperty("javax.net.ssl.keyStorePassword", keyStorePasswordProp);
        }
        return retval;
    }
}

