/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am.stmtcache;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.derby.client.am.stmtcache.StatementKey;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class JDBCStatementCache {
    private final LinkedHashMap<StatementKey, PreparedStatement> statements;

    public JDBCStatementCache(int maxSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("maxSize must be positive: " + maxSize);
        }
        this.statements = new BoundedLinkedHashMap(maxSize);
    }

    public synchronized PreparedStatement getCached(StatementKey statementKey) {
        SanityManager.ASSERT(statementKey != null, "statementKey is not supposed to be null");
        return (PreparedStatement)this.statements.remove(statementKey);
    }

    public synchronized boolean cacheStatement(StatementKey statementKey, PreparedStatement ps) {
        SanityManager.ASSERT(statementKey != null, "statementKey is not supposed to be null");
        SanityManager.ASSERT(ps != null, "ps is not supposed to be null");
        boolean alreadyCached = this.statements.containsKey(statementKey);
        if (!alreadyCached) {
            this.statements.put(statementKey, ps);
        }
        return !alreadyCached;
    }

    private static class BoundedLinkedHashMap
    extends LinkedHashMap<StatementKey, PreparedStatement> {
        private final int maxSize;

        public BoundedLinkedHashMap(int maxCapacity) {
            this.maxSize = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<StatementKey, PreparedStatement> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.maxSize;
            if (remove && eldest != null) {
                try {
                    eldest.getValue().close();
                }
                catch (SQLException ex) {
                    SanityManager.THROWASSERT("Failed to close prepared statement marked for cache removal", ex);
                }
            }
            return remove;
        }
    }
}

