/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.shared.common.security.SystemPermission;

public final class DatabasePermission
extends Permission {
    public static final String URL_PROTOCOL_DIRECTORY = "directory:";
    public static final String URL_PATH_INCLUSIVE_STRING = "<<ALL FILES>>";
    public static final char URL_PATH_INCLUSIVE_CHAR = 'I';
    public static final char URL_PATH_SEPARATOR_CHAR = '/';
    public static final char URL_PATH_RELATIVE_CHAR = '.';
    public static final char URL_PATH_WILDCARD_CHAR = '*';
    public static final char URL_PATH_RECURSIVE_CHAR = '-';
    public static final String URL_PATH_SEPARATOR_STRING = String.valueOf('/');
    public static final String URL_PATH_RELATIVE_STRING = String.valueOf('.');
    public static final String URL_PATH_RELATIVE_PREFIX = URL_PATH_RELATIVE_STRING + "/";
    public static final String URL_PATH_WILDCARD_STRING = String.valueOf('*');
    public static final String URL_PATH_WILDCARD_SUFFIX = URL_PATH_SEPARATOR_STRING + "*";
    public static final String URL_PATH_RECURSIVE_STRING = String.valueOf('-');
    public static final String URL_PATH_RECURSIVE_SUFFIX = URL_PATH_SEPARATOR_STRING + "-";
    public static final String CREATE = "create";
    protected static final List<String> LEGAL_ACTIONS = new ArrayList<String>();
    private String actions;
    private transient String path;
    private transient String parentPath;
    private transient char pathType;

    public DatabasePermission(String url, String actions) throws IOException {
        super(url);
        this.initActions(actions);
        this.initLocation(url);
    }

    protected void initActions(String actions) {
        if (actions == null) {
            throw new NullPointerException("actions can't be null");
        }
        if (actions.length() == 0) {
            throw new IllegalArgumentException("actions can't be empty");
        }
        Set<String> actionSet = SystemPermission.parseActions(actions);
        for (String action : actionSet) {
            if (LEGAL_ACTIONS.contains(action)) continue;
            String msg = "Illegal action '" + action + "'";
            throw new IllegalArgumentException(msg);
        }
        ArrayList<String> legalActions = new ArrayList<String>(LEGAL_ACTIONS);
        legalActions.retainAll(actionSet);
        this.actions = SystemPermission.buildActionsString(legalActions);
    }

    protected void initLocation(String url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL can't be null");
        }
        if (url.length() == 0) {
            throw new IllegalArgumentException("URL can't be empty");
        }
        if (!url.startsWith(URL_PROTOCOL_DIRECTORY)) {
            String msg = "Unsupported protocol in URL '" + url + "'";
            throw new IllegalArgumentException(msg);
        }
        Object p = url.substring(URL_PROTOCOL_DIRECTORY.length());
        if (((String)p).equals(URL_PATH_INCLUSIVE_STRING)) {
            this.pathType = (char)73;
        } else if (((String)p).equals(URL_PATH_RECURSIVE_STRING)) {
            this.pathType = (char)45;
            p = URL_PATH_RELATIVE_PREFIX;
        } else if (((String)p).equals(URL_PATH_WILDCARD_STRING)) {
            this.pathType = (char)42;
            p = URL_PATH_RELATIVE_PREFIX;
        } else if (((String)p).endsWith(URL_PATH_RECURSIVE_SUFFIX)) {
            this.pathType = (char)45;
            p = ((String)p).substring(0, ((String)p).length() - 1);
        } else if (((String)p).endsWith(URL_PATH_WILDCARD_SUFFIX)) {
            this.pathType = (char)42;
            p = ((String)p).substring(0, ((String)p).length() - 1);
        } else {
            this.pathType = (char)47;
        }
        if (this.pathType == 'I') {
            this.path = URL_PATH_INCLUSIVE_STRING;
        } else {
            File f;
            if (((String)p).startsWith(URL_PATH_RELATIVE_PREFIX)) {
                String cwd = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("user.dir");
                    }
                });
                p = cwd + URL_PATH_SEPARATOR_STRING + (String)p;
            }
            final String absPath = p;
            try {
                f = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws IOException {
                        return new File(absPath).getCanonicalFile();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getCause();
            }
            this.path = f.getPath();
            this.parentPath = this.pathType != '/' ? this.path : f.getParent();
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission that = (DatabasePermission)p;
        if (this.pathType == 'I') {
            return true;
        }
        if (that.pathType == 'I') {
            return false;
        }
        if (this.pathType == '-') {
            return that.parentPath != null && that.parentPath.startsWith(this.path);
        }
        if (that.pathType == '-') {
            return false;
        }
        if (this.pathType == '*') {
            return this.path.equals(that.parentPath);
        }
        if (that.pathType == '*') {
            return false;
        }
        return this.path.equals(that.path);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DatabasePermission)) {
            return false;
        }
        DatabasePermission that = (DatabasePermission)obj;
        return this.pathType == that.pathType && this.path.equals(that.path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode() ^ this.pathType;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.initLocation(this.getName());
        this.initActions(this.getActions());
    }

    static {
        LEGAL_ACTIONS.add(CREATE);
    }
}

