/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BitConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class RowResultSetNode
extends FromTable {
    SubqueryList subquerys;
    private List<AggregateNode> aggregates;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();

    RowResultSetNode(ResultColumnList valuesClause, Properties tableProperties, ContextManager cm) {
        super(null, tableProperties, cm);
        this.setResultColumns(valuesClause);
        if (this.getResultColumns() != null) {
            this.getResultColumns().markInitialSize();
        }
    }

    String statementToString() {
        return "VALUES";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquerys != null) {
            this.printLabel(depth, "subquerys: ");
            this.subquerys.treePrint(depth + 1);
        }
        this.printQueryExpressionSuffixClauses(depth, this.qec);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.subquerys != null && this.subquerys.referencesSessionSchema();
    }

    @Override
    ResultSetNode enhanceRCLForInsert(InsertNode target, boolean inOrder, int[] colMap) throws StandardException {
        if (!inOrder || this.getResultColumns().size() < target.resultColumnList.size()) {
            this.setResultColumns(this.getRCLForInsert(target, colMap));
        }
        return this;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        this.getCostEstimate().setCost(0.0, 1.0, 1.0);
        rowOrdering.optimizableAlwaysOrdered(this);
        return this.getCostEstimate();
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
        this.subquerys = new SubqueryList(this.getContextManager());
        this.aggregates = new ArrayList<AggregateNode>();
        this.getResultColumns().checkForInvalidDefaults();
        int nestingLevel = fromListParam.size() == 0 ? 0 : ((FromTable)fromListParam.elementAt(0)).getLevel() + 1;
        this.setLevel(nestingLevel);
        fromListParam.insertElementAt(this, 0);
        this.getResultColumns().bindExpressions(fromListParam, this.subquerys, this.aggregates);
        fromListParam.removeElementAt(0);
        if (!this.aggregates.isEmpty()) {
            throw StandardException.newException("42903", new Object[0]);
        }
        SelectNode.checkNoWindowFunctions(this.getResultColumns(), "VALUES");
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                obl.pullUpOrderByColumns(this);
                obl.bindOrderByColumns(this);
            }
            RowResultSetNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
    }

    @Override
    void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
    }

    @Override
    void bindTargetExpressions(FromList fromListParam) throws StandardException {
        this.bindExpressions(fromListParam);
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        if (bindingRCL == null) {
            bindingRCL = this.getResultColumns();
        }
        this.getResultColumns().bindUntypedNullsToResultColumns(bindingRCL);
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    @Override
    String getExposedName() throws StandardException {
        return null;
    }

    @Override
    void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        this.qec.setOffset(offset);
        this.qec.setFetchFirst(fetchFirst);
        this.qec.setHasJDBCLimitClause(hasJDBClimitClause);
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.getResultColumns().preprocess(numTables, fromList, this.subquerys, new PredicateList(this.getContextManager()));
        this.setReferencedTableMap(new JBitSet(numTables));
        this.getReferencedTableMap().set(this.tableNumber);
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl == null || obl.size() <= 1) continue;
            obl.removeDupColumns();
        }
        return this;
    }

    @Override
    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this.genProjectRestrict(numTables);
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        ResultColumnList prRCList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        prRCList.genVirtualColumnNodes(this, this.getResultColumns());
        PredicateList predList = new PredicateList(this.getContextManager());
        predList.addPredicate(predicate);
        return new ProjectRestrictNode(this, prRCList, null, predList, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        if (this.subquerys != null && this.subquerys.size() > 0) {
            return false;
        }
        if (this.aggregates != null && !this.aggregates.isEmpty()) {
            return false;
        }
        if (!this.getResultColumns().isCloneable()) {
            return false;
        }
        boolean nonRowResultSetFound = false;
        int flSize = fromList.size();
        for (int index = 0; index < flSize; ++index) {
            FromTable ft = (FromTable)fromList.elementAt(index);
            if (ft instanceof FromSubquery) {
                ResultSetNode subq = ((FromSubquery)ft).getSubquery();
                if (subq instanceof RowResultSetNode) continue;
                nonRowResultSetFound = true;
                break;
            }
            nonRowResultSetFound = true;
            break;
        }
        return nonRowResultSetFound;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(0.0, outerRows, outerRows);
        this.subquerys.optimize(dataDictionary, outerRows);
        return this;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        return (Optimizable)((Object)this.modifyAccessPaths());
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        FromTable treeTop = this;
        this.subquerys.modifyAccessPaths();
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                treeTop = new OrderByNode(treeTop, obl, this.tableProperties, this.getContextManager());
            }
            ValueNode offset = this.qec.getOffset(i);
            ValueNode fetchFirst = this.qec.getFetchFirst(i);
            Boolean hasJDBClimitClause = this.qec.getHasJDBCLimitClause()[i];
            if (offset == null && fetchFirst == null) continue;
            ResultColumnList newRcl = treeTop.getResultColumns().copyListAndObjects();
            newRcl.genVirtualColumnNodes(treeTop, treeTop.getResultColumns());
            treeTop = new RowCountNode(treeTop, newRcl, offset, fetchFirst, hasJDBClimitClause, this.getContextManager());
        }
        return treeTop;
    }

    @Override
    boolean returnsAtMostOneRow() {
        return true;
    }

    @Override
    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns().visibleSize() <= typeColumns.size(), "More columns in ResultColumnList than in base table");
        int rclSize = this.getResultColumns().size();
        for (int index = 0; index < rclSize; ++index) {
            TypeId colTypeId;
            ResultColumn typeCol;
            ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(index);
            ValueNode re = rc.getExpression();
            if (re.requiresTypeFromContext()) {
                typeCol = (ResultColumn)typeColumns.elementAt(index);
                re.setType(typeCol.getTypeServices());
                continue;
            }
            if (re instanceof CharConstantNode) {
                typeCol = (ResultColumn)typeColumns.elementAt(index);
                colTypeId = typeCol.getTypeId();
                if (colTypeId.isStringTypeId()) {
                    if (colTypeId.getJDBCTypeId() == 1) continue;
                    int maxWidth = re.getTypeServices().getMaximumWidth();
                    re.setType(new DataTypeDescriptor(colTypeId, true, maxWidth));
                    continue;
                }
                if (!colTypeId.isBitTypeId()) continue;
                if (colTypeId.getJDBCTypeId() == -3) {
                    TypeId tId = TypeId.getBuiltInTypeId(12);
                    re.setType(new DataTypeDescriptor(tId, true));
                    typeColumns.setElementAt(typeCol, index);
                    continue;
                }
                if (colTypeId.getJDBCTypeId() != -4) continue;
                TypeId tId = TypeId.getBuiltInTypeId(-1);
                re.setType(new DataTypeDescriptor(tId, true));
                typeColumns.setElementAt(typeCol, index);
                continue;
            }
            if (!(re instanceof BitConstantNode)) continue;
            typeCol = (ResultColumn)typeColumns.elementAt(index);
            colTypeId = typeCol.getTypeId();
            if (colTypeId.isBitTypeId()) {
                if (colTypeId.getJDBCTypeId() == -2 || colTypeId.getJDBCTypeId() == 2004) continue;
                int maxWidth = re.getTypeServices().getMaximumWidth();
                re.setType(new DataTypeDescriptor(colTypeId, true, maxWidth));
                continue;
            }
            if (!colTypeId.isStringTypeId()) continue;
            if (colTypeId.getJDBCTypeId() == 12) {
                TypeId tId = TypeId.getBuiltInTypeId(-3);
                re.setType(new DataTypeDescriptor(tId, true));
                typeColumns.setElementAt(typeCol, index);
                continue;
            }
            if (colTypeId.getJDBCTypeId() != -1) continue;
            TypeId tId = TypeId.getBuiltInTypeId(-4);
            re.setType(new DataTypeDescriptor(tId, true));
            typeColumns.setElementAt(typeCol, index);
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns() != null, "Tree structure bad");
        this.setCostEstimate(this.getFinalCostEstimate());
        boolean canCache = this.canWeCacheResults();
        this.assignResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        this.getResultColumns().generate(acb, mb);
        mb.push(canCache);
        mb.push(this.getResultSetNumber());
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor ttd, ResultColumnList tcl, boolean allowDefaults) throws StandardException {
        this.getResultColumns().replaceOrForbidDefaults(ttd, tcl, allowDefaults);
    }

    @Override
    void optimizeSubqueries(DataDictionary dd, double rowCount) throws StandardException {
        this.subquerys.optimize(dd, rowCount);
    }

    @Override
    void adjustForSortElimination() {
    }

    private boolean canWeCacheResults() throws StandardException {
        HasVariantValueNodeVisitor visitor = new HasVariantValueNodeVisitor(2, true);
        super.accept(visitor);
        boolean canCache = !visitor.hasVariant();
        return canCache;
    }
}

