/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.StringReader;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.SQLParser;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.TokenMgrError;
import org.apache.derby.impl.sql.compile.UCode_CharStream;
import org.apache.derby.shared.common.error.StandardException;

public class ParserImpl
implements Parser {
    static final int LARGE_TOKEN_SIZE = 128;
    private SQLParser cachedParser;
    private Object cachedTokenManager;
    private CharStream charStream;
    protected String SQLtext;
    private final CompilerContext cc;

    public ParserImpl(CompilerContext cc) {
        this.cc = cc;
    }

    @Override
    public Visitable parseStatement(String statementSQLText) throws StandardException {
        return this.parseStatement(statementSQLText, null);
    }

    protected Object getTokenManager() {
        SQLParserTokenManager tm = (SQLParserTokenManager)this.cachedTokenManager;
        if (tm == null) {
            tm = new SQLParserTokenManager(this.charStream);
            this.cachedTokenManager = tm;
        } else {
            tm.ReInit(this.charStream);
        }
        return tm;
    }

    private SQLParser getParser() {
        SQLParserTokenManager tm = (SQLParserTokenManager)this.getTokenManager();
        SQLParser p = this.cachedParser;
        if (p == null) {
            p = new SQLParser(tm);
            p.setCompilerContext(this.cc);
            this.cachedParser = p;
        } else {
            p.ReInit(tm);
        }
        return p;
    }

    @Override
    public Visitable parseStatement(String statementSQLText, Object[] paramDefaults) throws StandardException {
        return this.parseStatementOrSearchCondition(statementSQLText, paramDefaults, true);
    }

    private Visitable parseStatementOrSearchCondition(String sql, Object[] paramDefaults, boolean isStatement) throws StandardException {
        StringReader sqlText = new StringReader(sql);
        if (this.charStream == null) {
            this.charStream = new UCode_CharStream(sqlText, 1, 1, 128);
        } else {
            this.charStream.ReInit(sqlText, 1, 1, 128);
        }
        this.SQLtext = sql;
        try {
            SQLParser p = this.getParser();
            return isStatement ? p.Statement(sql, paramDefaults) : p.SearchCondition(sql);
        }
        catch (ParseException e) {
            throw StandardException.newException("42X01", e.getMessage());
        }
        catch (TokenMgrError e) {
            this.cachedParser = null;
            throw StandardException.newException("42X02", e.getMessage());
        }
    }

    @Override
    public Visitable parseSearchCondition(String sqlFragment) throws StandardException {
        return this.parseStatementOrSearchCondition(sqlFragment, null, false);
    }

    @Override
    public String getSQLtext() {
        return this.SQLtext;
    }
}

