/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

abstract class ConstantNode
extends ValueNode {
    DataValueDescriptor value;

    ConstantNode(TypeId typeId, boolean nullable, int maximumWidth, ContextManager cm) throws StandardException {
        super(cm);
        this.setType(typeId, nullable, maximumWidth);
    }

    ConstantNode(ContextManager cm) {
        super(cm);
    }

    void setValue(DataValueDescriptor value) {
        this.value = value;
    }

    DataValueDescriptor getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "value: " + this.value + "\n" + super.toString();
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    ValueNode getClone() {
        return this;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return true;
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.isNull()) {
            acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        } else {
            this.generateConstant(acb, mb);
            acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
        }
    }

    abstract void generateConstant(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    boolean isNull() {
        return this.value == null || this.value.isNull();
    }

    @Override
    protected int getOrderableVariantType() {
        return 3;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            ConstantNode other = (ConstantNode)o;
            return other.getValue() == null && this.getValue() == null || other.getValue() != null && other.getValue().compare(this.getValue()) == 0;
        }
        return false;
    }
}

