/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.tools;

import java.io.IOException;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.tools.PlanExporter;
import org.apache.derby.tools.SignatureChecker;
import org.apache.derby.tools.dblook;
import org.apache.derby.tools.ij;
import org.apache.derby.tools.sysinfo;

public class run {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            run.printUsage();
        } else if (args[0].equals("ij")) {
            ij.main(run.trimArgs(args));
        } else if (args[0].equals("sysinfo")) {
            sysinfo.main(run.trimArgs(args));
        } else if (args[0].equals("dblook")) {
            dblook.main(run.trimArgs(args));
        } else if (args[0].equals("server")) {
            NetworkServerControl.main(run.trimArgs(args));
        } else if (args[0].equals("SignatureChecker")) {
            SignatureChecker.main(run.trimArgs(args));
        } else if (args[0].equals("PlanExporter")) {
            PlanExporter.main(run.trimArgs(args));
        } else {
            run.printUsage();
        }
    }

    private run() {
    }

    private static String[] trimArgs(String[] args) {
        String[] trimmed = new String[args.length - 1];
        System.arraycopy(args, 1, trimmed, 0, args.length - 1);
        return trimmed;
    }

    public static void printUsage() {
        LocalizedResource locRes = LocalizedResource.getInstance();
        System.err.println(locRes.getTextMessage("RUN_Usage", new Object[0]));
    }
}

