/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.impl.tools.ij.mtTestCase;
import org.apache.derby.impl.tools.ij.mtTime;

public class mtTestSuite {
    private Vector cases;
    private Vector last;
    private Vector init;
    private mtTime time;
    private int numThreads;
    private String rootDir = null;

    mtTestSuite(int numThreads, mtTime time, Vector initCases, Vector testCases, Vector finalCases) {
        this.numThreads = numThreads;
        this.time = time;
        this.cases = testCases;
        this.init = initCases;
        this.last = finalCases;
    }

    public void init() {
        boolean loadInitFailed = this.loadCases(this.init);
        boolean loadTestsFailed = this.loadCases(this.cases);
        boolean loadLastFailed = this.loadCases(this.last);
        if (loadInitFailed || loadTestsFailed || loadLastFailed) {
            throw new Error("Initialization Error");
        }
    }

    private boolean loadCases(Vector cases) {
        if (cases == null) {
            return false;
        }
        boolean gotError = false;
        Enumeration e = cases.elements();
        while (e.hasMoreElements()) {
            mtTestCase tcase = (mtTestCase)e.nextElement();
            try {
                tcase.initialize(this.rootDir);
            }
            catch (Throwable t) {
                gotError = true;
            }
        }
        return gotError;
    }

    public void setRoot(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getRoot() {
        return this.rootDir;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public Vector getCases() {
        return this.cases;
    }

    public Vector getInitCases() {
        return this.init;
    }

    public Vector getFinalCases() {
        return this.last;
    }

    public mtTime getTime() {
        return this.time;
    }

    public long getTimeMillis() {
        return (this.time.hours * 360 + this.time.minutes * 60 + this.time.seconds) * 1000;
    }

    public String toString() {
        int i;
        String str = "TEST CASES\nNumber of Threads: " + this.numThreads;
        str = str + "\nTime: " + this.time;
        str = str + "\nNumber of Initializers: " + this.init.size() + "\n";
        int len = this.init.size();
        for (i = 0; i < len; ++i) {
            str = str + this.init.elementAt(i).toString() + "\n";
        }
        str = str + "\nNumber of Cases: " + this.cases.size() + "\n";
        len = this.cases.size();
        for (i = 0; i < len; ++i) {
            str = str + this.cases.elementAt(i).toString() + "\n";
        }
        str = str + "\nNumber of Final Cases: " + this.last.size() + "\n";
        len = this.last.size();
        for (i = 0; i < len; ++i) {
            str = str + this.last.elementAt(i).toString() + "\n";
        }
        return str;
    }

    public mtTestCase grabTestCase() {
        int caseNum;
        mtTestCase testCase;
        int numCases = this.cases.size();
        while (!(testCase = (mtTestCase)this.cases.elementAt(caseNum = (int)(Math.random() * 1311.0 % (double)numCases))).grab()) {
        }
        return testCase;
    }
}

