/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ConnectionEnv;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.StatementFinder;
import org.apache.derby.impl.tools.ij.TokenMgrError;
import org.apache.derby.impl.tools.ij.UCode_CharStream;
import org.apache.derby.impl.tools.ij.ij;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijFatalException;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijRowResult;
import org.apache.derby.impl.tools.ij.ijTokenException;
import org.apache.derby.impl.tools.ij.ijTokenManager;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.tools.JDBCDisplayUtil;

public class utilMain {
    private StatementFinder[] commandGrabber;
    UCode_CharStream charStream;
    ijTokenManager ijTokMgr;
    ij ijParser;
    ConnectionEnv[] connEnv;
    private int currCE;
    private final int numConnections;
    private boolean fileInput;
    private boolean initialFileInput;
    private boolean mtUse;
    private boolean firstRun = true;
    private LocalizedOutput out = null;
    private Hashtable ignoreErrors;
    private final boolean showErrorCode;
    private final String ijExceptionTrace;
    public static final int BUFFEREDFILESIZE = 2048;
    Stack<StatementFinder> oldGrabbers = new Stack();
    LocalizedResource langUtil = LocalizedResource.getInstance();

    utilMain(int numConnections, LocalizedOutput out) throws ijFatalException {
        this(numConnections, out, null);
    }

    utilMain(int numConnections, LocalizedOutput out, boolean loadSystemProperties) throws ijFatalException {
        this(numConnections, out, null);
        if (loadSystemProperties) {
            this.initFromEnvironment();
        }
    }

    public utilMain(int numConnections, LocalizedOutput out, Hashtable ignoreErrors) throws ijFatalException {
        this.charStream = new UCode_CharStream(new StringReader(" "), 1, 1);
        this.ijTokMgr = new ijTokenManager(this.charStream);
        this.ijParser = new ij(this.ijTokMgr, this);
        this.out = out;
        if (ignoreErrors != null) {
            this.ignoreErrors = (Hashtable)ignoreErrors.clone();
        }
        this.showErrorCode = Boolean.valueOf(util.getSystemProperty("ij.showErrorCode"));
        this.ijExceptionTrace = util.getSystemProperty("ij.exceptionTrace");
        this.numConnections = numConnections;
        this.commandGrabber = new StatementFinder[numConnections];
        this.connEnv = new ConnectionEnv[numConnections];
        for (int ictr = 0; ictr < numConnections; ++ictr) {
            this.commandGrabber[ictr] = new StatementFinder(this.langUtil.getNewInput(System.in), out);
            this.connEnv[ictr] = new ConnectionEnv(ictr, numConnections > 1, numConnections == 1);
        }
        this.currCE = 0;
        this.fileInput = false;
        this.initialFileInput = false;
        this.firstRun = true;
    }

    public void initFromEnvironment() {
        this.ijParser.initFromEnvironment();
        for (int ictr = 0; ictr < this.numConnections; ++ictr) {
            try {
                this.connEnv[ictr].init(this.out);
                continue;
            }
            catch (SQLException s) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)s);
                continue;
            }
            catch (ClassNotFoundException c) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)c);
                continue;
            }
            catch (InstantiationException i) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)i);
                continue;
            }
            catch (IllegalAccessException ia) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)ia);
                continue;
            }
            catch (NoSuchMethodException ia) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)ia);
                continue;
            }
            catch (InvocationTargetException ia) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)ia);
                continue;
            }
            catch (ijException ie) {
                JDBCDisplayUtil.ShowException(this.out, (Throwable)ie);
            }
        }
    }

    public void go(LocalizedInput[] in, LocalizedOutput out) throws ijFatalException {
        this.out = out;
        this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
        this.initialFileInput = !in[this.currCE].isStandardInput();
        this.fileInput = this.initialFileInput;
        for (int ictr = 0; ictr < this.commandGrabber.length; ++ictr) {
            this.commandGrabber[ictr].ReInit(in[ictr]);
        }
        if (this.firstRun) {
            InputStream versionStream = util.getResourceAsStream("/org/apache/derby/info/tools.properties");
            ProductVersionHolder ijVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(versionStream);
            String version = ijVersion != null ? "" + ijVersion.getMajorVersion() + "." + ijVersion.getMinorVersion() : "?";
            out.println(this.langUtil.getTextMessage("IJ_IjVers30C199", version));
            for (int i = this.connEnv.length - 1; i >= 0; --i) {
                Connection c = this.connEnv[i].getConnection();
                if (c == null) continue;
                JDBCDisplayUtil.ShowWarnings((PrintWriter)out, c);
            }
            this.firstRun = false;
            this.supportIJProperties(this.connEnv[this.currCE]);
        }
        this.out = out;
        this.runScriptGuts();
        this.cleanupGo(in);
    }

    public int goScript(Connection conn, LocalizedInput in) {
        this.connEnv[0].addSession(conn, null);
        this.ijParser.setConnection(this.connEnv[0], this.numConnections > 1);
        this.supportIJProperties(this.connEnv[0]);
        this.initialFileInput = !in.isStandardInput();
        this.fileInput = this.initialFileInput;
        this.commandGrabber[0].ReInit(in);
        return this.runScriptGuts();
    }

    private void supportIJProperties(ConnectionEnv env) {
        boolean showNoCountForSelect = Boolean.valueOf(util.getSystemProperty("ij.showNoCountForSelect"));
        JDBCDisplayUtil.setShowSelectCount(!showNoCountForSelect);
        boolean showNoConnectionsAtStart = Boolean.valueOf(util.getSystemProperty("ij.showNoConnectionsAtStart"));
        if (!showNoConnectionsAtStart) {
            try {
                ijResult result = this.ijParser.showConnectionsMethod(true);
                this.displayResult(this.out, result, env.getConnection());
            }
            catch (SQLException ex) {
                this.handleSQLException(this.out, ex);
            }
        }
    }

    private int runScriptGuts() {
        int scriptErrorCount = 0;
        boolean done = false;
        String command = null;
        while (!this.ijParser.exit && !done) {
            try {
                this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connEnv[this.currCE].doPrompt(true, this.out);
            try {
                command = null;
                this.out.flush();
                command = this.commandGrabber[this.currCE].nextStatement();
                while (command == null && !this.oldGrabbers.empty()) {
                    if (this.fileInput) {
                        this.commandGrabber[this.currCE].close();
                    }
                    this.commandGrabber[this.currCE] = this.oldGrabbers.pop();
                    if (this.oldGrabbers.empty()) {
                        this.fileInput = this.initialFileInput;
                    }
                    command = this.commandGrabber[this.currCE].nextStatement();
                }
                if (command == null && this.oldGrabbers.empty()) {
                    done = true;
                } else {
                    boolean elapsedTimeOn = this.ijParser.getElapsedTimeState();
                    long beginTime = 0L;
                    if (this.fileInput) {
                        this.out.println(command + ";");
                        this.out.flush();
                    }
                    this.charStream.ReInit(new StringReader(command), 1, 1);
                    this.ijTokMgr.ReInit(this.charStream);
                    this.ijParser.ReInit(this.ijTokMgr);
                    if (elapsedTimeOn) {
                        beginTime = System.currentTimeMillis();
                    }
                    ijResult result = this.ijParser.ijStatement();
                    this.displayResult(this.out, result, this.connEnv[this.currCE].getConnection());
                    if (elapsedTimeOn) {
                        long endTime = System.currentTimeMillis();
                        this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil", this.langUtil.getNumberAsString(endTime - beginTime)));
                    }
                }
            }
            catch (ParseException e) {
                if (command != null) {
                    scriptErrorCount += this.doCatch(command) ? 0 : 1;
                }
            }
            catch (TokenMgrError e) {
                if (command != null) {
                    scriptErrorCount += this.doCatch(command) ? 0 : 1;
                }
            }
            catch (SQLException e) {
                ++scriptErrorCount;
                this.handleSQLException(this.out, e);
            }
            catch (ijException e) {
                ++scriptErrorCount;
                this.out.println(this.langUtil.getTextMessage("IJ_IjErro0", e.getMessage()));
                this.doTrace(e);
            }
            catch (Throwable e) {
                ++scriptErrorCount;
                this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0", e.toString()));
                this.doTrace(e);
            }
            ++this.currCE;
            this.currCE %= this.connEnv.length;
        }
        return scriptErrorCount;
    }

    private void cleanupGo(LocalizedInput[] in) {
        int i;
        try {
            for (i = 0; i < this.connEnv.length; ++i) {
                this.connEnv[i].removeAllSessions();
            }
        }
        catch (SQLException se) {
            this.handleSQLException(this.out, se);
        }
        for (i = 0; i < this.numConnections; ++i) {
            try {
                in[i].close();
                continue;
            }
            catch (Exception e) {
                this.out.println(this.langUtil.getTextMessage("IJ_CannotCloseInFile", e.toString()));
            }
        }
        if (this.ijParser.exit || this.initialFileInput && !this.mtUse) {
            Driver d = null;
            try {
                d = DriverManager.getDriver("jdbc:derby:");
            }
            catch (Throwable e) {
                d = null;
            }
            if (d != null) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void displayResult(LocalizedOutput out, ijResult result, Connection conn) throws SQLException {
        if (result != null) {
            if (result.isConnection()) {
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                }
            } else if (result.isStatement()) {
                Statement s = result.getStatement();
                try {
                    JDBCDisplayUtil.DisplayResults(out, s, this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
            } else if (result.isNextRowOfResultSet()) {
                ResultSet r = result.getNextRowOfResultSet();
                JDBCDisplayUtil.DisplayCurrentRow(out, r, this.connEnv[this.currCE].getConnection());
            } else if (result.isVector()) {
                util.DisplayVector(out, result.getVector());
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                }
            } else if (result.isMulti()) {
                try {
                    util.DisplayMulti(out, (PreparedStatement)result.getStatement(), result.getResultSet(), this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                }
            } else if (result.isResultSet()) {
                ResultSet rs = result.getResultSet();
                try {
                    JDBCDisplayUtil.DisplayResults(out, rs, this.connEnv[this.currCE].getConnection(), result.getColumnDisplayList(), result.getColumnWidthList());
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
            } else if (result.isMultipleResultSetResult()) {
                List<ResultSet> resultSets = result.getMultipleResultSets();
                try {
                    JDBCDisplayUtil.DisplayMultipleResults(out, resultSets, this.connEnv[this.currCE].getConnection(), result.getColumnDisplayList(), result.getColumnWidthList());
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
            } else if (result.isException()) {
                JDBCDisplayUtil.ShowException(out, (Throwable)result.getException());
            }
        }
    }

    private boolean doCatch(String command) {
        try {
            boolean elapsedTimeOn = this.ijParser.getElapsedTimeState();
            long beginTime = 0L;
            if (elapsedTimeOn) {
                beginTime = System.currentTimeMillis();
            }
            ijResult result = this.ijParser.executeImmediate(command);
            this.displayResult(this.out, result, this.connEnv[this.currCE].getConnection());
            if (elapsedTimeOn) {
                long endTime = System.currentTimeMillis();
                this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil_4", this.langUtil.getNumberAsString(endTime - beginTime)));
            }
            return true;
        }
        catch (SQLException e) {
            this.handleSQLException(this.out, e);
        }
        catch (ijException i) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_5", i.getMessage()));
            this.doTrace(i);
        }
        catch (ijTokenException ie) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_6", ie.getMessage()));
            this.doTrace(ie);
        }
        catch (Throwable t) {
            this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0_7", t.toString()));
            this.doTrace(t);
        }
        return false;
    }

    private void handleSQLException(LocalizedOutput out, SQLException e) throws ijFatalException {
        String sqlState = null;
        SQLException fatalException = null;
        String errorCode = this.showErrorCode ? this.langUtil.getTextMessage("IJ_Erro0", this.langUtil.getNumberAsString(e.getErrorCode())) : "";
        boolean syntaxErrorOccurred = false;
        while (e != null) {
            block8: {
                block7: {
                    sqlState = e.getSQLState();
                    if ("42X01".equals(sqlState)) {
                        syntaxErrorOccurred = true;
                    }
                    if (this.ignoreErrors == null) break block7;
                    if (sqlState != null && this.ignoreErrors.get(sqlState) != null) break block8;
                    fatalException = e;
                }
                String st1 = JDBCDisplayUtil.mapNull(e.getSQLState(), this.langUtil.getTextMessage("IJ_NoSqls", new Object[0]));
                String st2 = JDBCDisplayUtil.mapNull(e.getMessage(), this.langUtil.getTextMessage("IJ_NoMess", new Object[0]));
                out.println(this.langUtil.getTextMessage("IJ_Erro012", st1, st2, errorCode));
                this.doTrace(e);
            }
            e = e.getNextException();
        }
        if (fatalException != null) {
            throw new ijFatalException(fatalException);
        }
        if (syntaxErrorOccurred) {
            out.println(this.langUtil.getTextMessage("IJ_SuggestHelp", new Object[0]));
        }
    }

    private void doTrace(Throwable t) {
        if (this.ijExceptionTrace != null) {
            t.printStackTrace(this.out);
        }
        this.out.flush();
    }

    void newInput(String fileName) {
        FileInputStream newFile = null;
        try {
            newFile = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            throw ijException.fileNotFound();
        }
        if (newFile == null) {
            return;
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewInput(new BufferedInputStream(newFile, 2048)), null);
        this.fileInput = true;
    }

    void newResourceInput(String resourceName) {
        InputStream is = util.getResourceAsStream(resourceName);
        if (is == null) {
            throw ijException.resourceNotFound();
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewEncodedInput(new BufferedInputStream(is, 2048), "UTF8"), null);
        this.fileInput = true;
    }

    static void doPrompt(boolean newStatement, LocalizedOutput out, String tag) {
        if (newStatement) {
            out.print("ij" + (tag == null ? "" : tag) + "> ");
        } else {
            out.print("> ");
        }
        out.flush();
    }

    void setMtUse(boolean b) {
        this.mtUse = b;
    }

    private void checkScrollableCursor(ResultSet rs, String operation) throws ijException, SQLException {
        if (rs.getType() == 1003) {
            throw ijException.forwardOnlyCursor(operation);
        }
    }

    ijResult absolute(ResultSet rs, int row) throws SQLException {
        this.checkScrollableCursor(rs, "ABSOLUTE");
        return new ijRowResult(rs, rs.absolute(row));
    }

    ijResult relative(ResultSet rs, int row) throws SQLException {
        this.checkScrollableCursor(rs, "RELATIVE");
        return new ijRowResult(rs, rs.relative(row));
    }

    ijResult beforeFirst(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "BEFORE FIRST");
        rs.beforeFirst();
        return new ijRowResult(rs, false);
    }

    ijResult first(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "FIRST");
        return new ijRowResult(rs, rs.first());
    }

    ijResult afterLast(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "AFTER LAST");
        rs.afterLast();
        return new ijRowResult(rs, false);
    }

    ijResult last(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "LAST");
        return new ijRowResult(rs, rs.last());
    }

    ijResult previous(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "PREVIOUS");
        return new ijRowResult(rs, rs.previous());
    }

    int getCurrentRowNumber(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "GETCURRENTROWNUMBER");
        return rs.getRow();
    }
}

