/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.index.B2I;

public class B2IStaticCompiledInfo
implements StaticCompiledOpenConglomInfo {
    B2I b2i;
    StaticCompiledOpenConglomInfo base_table_static_info;

    public B2IStaticCompiledInfo() {
    }

    B2IStaticCompiledInfo(TransactionController tc, B2I b2i) throws StandardException {
        this.b2i = b2i;
        this.base_table_static_info = tc.getStaticCompiledConglomInfo(b2i.baseConglomerateId);
    }

    @Override
    public DataValueDescriptor getConglom() {
        return this.b2i;
    }

    @Override
    public boolean isNull() {
        return this.b2i == null;
    }

    @Override
    public void restoreToNull() {
        this.b2i = null;
    }

    @Override
    public int getTypeFormatId() {
        return 360;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.b2i = new B2I();
        this.b2i.readExternal(in);
        this.base_table_static_info = (StaticCompiledOpenConglomInfo)in.readObject();
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.b2i = new B2I();
        this.b2i.readExternal(in);
        this.base_table_static_info = (StaticCompiledOpenConglomInfo)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.b2i.writeExternal(out);
        out.writeObject(this.base_table_static_info);
    }
}

