/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.store.access.RAMTransaction;
import org.apache.derby.shared.common.sanity.SanityManager;

final class RAMTransactionContext
extends ContextImpl {
    private RAMTransaction transaction;
    private final boolean abortAll;

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        SanityManager.ASSERT(this.getContextManager() != null);
        boolean destroy = false;
        if (!this.abortAll && error instanceof StandardException) {
            StandardException se = (StandardException)error;
            if (se.getSeverity() < 30000) {
                return;
            }
            if (se.getSeverity() >= 40000) {
                destroy = true;
            }
        } else {
            destroy = true;
        }
        if (this.transaction != null) {
            try {
                this.transaction.invalidateConglomerateCache();
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("got error while invalidating cache.", se);
            }
            this.transaction.closeControllers(true);
        }
        if (destroy) {
            this.transaction = null;
            this.popMe();
        }
    }

    RAMTransactionContext(ContextManager cm, String context_id, RAMTransaction theTransaction, boolean abortAll) throws StandardException {
        super(cm, context_id);
        this.abortAll = abortAll;
        this.transaction = theTransaction;
        this.transaction.setContext(this);
    }

    RAMTransaction getTransaction() {
        return this.transaction;
    }

    void setTransaction(RAMTransaction transaction) {
        this.transaction = transaction;
    }
}

