/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class ReferencedKeyRIChecker
extends GenericRIChecker {
    private ScanController refKeyIndexScan = null;
    private final DataValueDescriptor[] refKey = new DataValueDescriptor[this.numColumns];
    private BackingStoreHashtable deletedKeys = null;

    ReferencedKeyRIChecker(LanguageConnectionContext lcc, TransactionController tc, FKInfo fkinfo) throws StandardException {
        super(lcc, tc, fkinfo);
        if (this.fkInfo.type != 2) {
            SanityManager.THROWASSERT("invalid type " + this.fkInfo.type + " for a ReferencedKeyRIChecker");
        }
    }

    @Override
    void doCheck(Activation a, ExecRow row, boolean restrictCheckOnly, int deferredRowReq) throws StandardException {
        if (this.isAnyFieldNull(row)) {
            return;
        }
        if (this.fkInfo.refConstraintIsDeferrable && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(a), this.fkInfo.refConstraintID)) {
            if (restrictCheckOnly) {
                this.rememberKey(row);
                return;
            }
            if (this.isDuplicated(row, deferredRowReq)) {
                return;
            }
        }
        for (int i = 0; i < this.fkInfo.fkConglomNumbers.length; ++i) {
            if (restrictCheckOnly && this.fkInfo.raRules[i] != 1) continue;
            ScanController scan = this.getScanController(this.fkInfo.fkConglomNumbers[i], this.fkScocis[i], this.fkDcocis[i], row);
            if (scan.next()) {
                this.close();
                UUID fkId = this.fkInfo.fkIds[i];
                if (this.fkInfo.deferrable[i] && this.fkInfo.raRules[i] != 1 && this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(a), fkId)) {
                    this.deferredRowsHashTable = DeferredConstraintsMemory.rememberFKViolation(this.lcc, this.deferredRowsHashTable, this.fkInfo.fkIds[i], this.indexQualifierRow.getRowArray(), this.fkInfo.schemaName, this.fkInfo.tableName);
                } else {
                    StandardException se = StandardException.newException("23503", this.fkInfo.fkConstraintNames[i], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(row, this.fkInfo.colArray));
                    throw se;
                }
            }
            scan.next();
        }
    }

    private void rememberKey(ExecRow rememberRow) throws StandardException {
        if (this.deletedKeys == null) {
            this.identityMap = new int[this.numColumns];
            for (int i = 0; i < this.numColumns; ++i) {
                this.identityMap[i] = i;
            }
            this.deletedKeys = new BackingStoreHashtable(this.tc, null, this.identityMap, true, -1L, -1L, -1, -1.0f, false, false);
        }
        DataValueDescriptor[] row = rememberRow.getRowArray();
        for (int i = 0; i < this.numColumns; ++i) {
            this.refKey[i] = row[this.fkInfo.colArray[i] - 1];
        }
        Object hashKey = KeyHasher.buildHashKey(this.refKey, this.identityMap);
        DataValueDescriptor[] savedRow = (DataValueDescriptor[])this.deletedKeys.remove(hashKey);
        if (savedRow == null) {
            savedRow = new DataValueDescriptor[this.numColumns + 1];
            System.arraycopy(this.refKey, 0, savedRow, 0, this.numColumns);
            savedRow[this.numColumns] = new SQLLongint(1L);
        } else {
            savedRow[this.numColumns] = new SQLLongint(((SQLLongint)savedRow[this.numColumns]).getLong() + 1L);
        }
        this.deletedKeys.putRow(false, savedRow, null);
    }

    public void postCheck() throws StandardException {
        if (!this.fkInfo.refConstraintIsDeferrable) {
            return;
        }
        int indexOfFirstRestrict = -1;
        for (int i = 0; i < this.fkInfo.fkConglomNumbers.length; ++i) {
            if (this.fkInfo.raRules[i] != 1) continue;
            indexOfFirstRestrict = i;
            break;
        }
        if (indexOfFirstRestrict == -1) {
            return;
        }
        if (this.deletedKeys != null) {
            Enumeration<Object> e = this.deletedKeys.elements();
            while (e.hasMoreElements()) {
                Object[] row = (DataValueDescriptor[])e.nextElement();
                DataValueDescriptor[] key = new DataValueDescriptor[row.length - 1];
                System.arraycopy(row, 0, key, 0, key.length);
                long requiredCount = row[row.length - 1].getLong() + 1L;
                if (this.isDuplicated(key, requiredCount)) continue;
                int[] oneBasedIdentityMap = new int[this.numColumns];
                for (int i = 0; i < this.numColumns; ++i) {
                    oneBasedIdentityMap[i] = i + 1;
                }
                StandardException se = StandardException.newException("23503", this.fkInfo.fkConstraintNames[indexOfFirstRestrict], this.fkInfo.tableName, StatementUtil.typeName(this.fkInfo.stmtType), RowUtil.toString(row, oneBasedIdentityMap));
                throw se;
            }
        }
    }

    private boolean isDuplicated(ExecRow row, int deferredRowReq) throws StandardException {
        DataValueDescriptor[] indexRowArray = row.getRowArray();
        for (int i = 0; i < this.numColumns; ++i) {
            this.refKey[i] = indexRowArray[this.fkInfo.colArray[i] - 1];
        }
        return this.isDuplicated(this.refKey, (long)deferredRowReq);
    }

    private boolean isDuplicated(DataValueDescriptor[] key, long deferredRowReq) throws StandardException {
        if (this.refKeyIndexScan == null) {
            this.refKeyIndexScan = this.tc.openScan(this.fkInfo.refConglomNumber, false, 0, 6, 4, null, key, 1, null, key, -1);
        } else {
            this.refKeyIndexScan.reopenScan(key, 1, null, key, -1);
        }
        boolean foundRow = this.refKeyIndexScan.next();
        while (--deferredRowReq > 0L && foundRow) {
            foundRow = this.refKeyIndexScan.next();
        }
        return deferredRowReq == 0L && foundRow;
    }

    @Override
    void close() throws StandardException {
        if (this.refKeyIndexScan != null) {
            this.refKeyIndexScan.close();
            this.refKeyIndexScan = null;
        }
        if (this.deletedKeys != null) {
            this.deletedKeys.close();
            this.deletedKeys = null;
        }
        this.identityMap = null;
        super.close();
    }
}

