/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateSchemaConstantAction
extends DDLConstantAction {
    private final String aid;
    private final String schemaName;

    CreateSchemaConstantAction(String schemaName, String aid) {
        this.schemaName = schemaName;
        this.aid = aid;
    }

    public String toString() {
        return "CREATE SCHEMA " + this.schemaName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        this.executeConstantActionMinion(activation, tc);
    }

    public void executeConstantAction(Activation activation, TransactionController tc) throws StandardException {
        this.executeConstantActionMinion(activation, tc);
    }

    private void executeConstantActionMinion(Activation activation, TransactionController tc) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, lcc.getTransactionExecute(), false);
        if (sd != null && sd.getUUID() != null) {
            throw StandardException.newException("X0Y68.S", "Schema", this.schemaName);
        }
        UUID tmpSchemaId = dd.getUUIDFactory().createUUID();
        String thisAid = this.aid;
        if (thisAid == null) {
            thisAid = lcc.getCurrentUserId(activation);
        }
        dd.startWriting(lcc);
        sd = ddg.newSchemaDescriptor(this.schemaName, thisAid, tmpSchemaId);
        dd.addDescriptor(sd, null, 3, false, tc);
    }
}

