/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CounterOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.CollationElementsInterface;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    private static final char PAD = ' ';
    protected static final int RETURN_SPACE_THRESHOLD = 4096;
    private static final int GROWBY_FOR_CHAR = 64;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLChar.class);
    private static final char[] BLANKS = new char[40];
    protected static final StreamHeaderGenerator CHAR_HEADER_GENERATOR;
    private String value;
    private char[] rawData;
    private int rawLength = -1;
    private CollationKey cKey;
    protected Clob _clobValue;
    InputStream stream;
    private LocaleFinder localeFinder;
    char[][] arg_passer = new char[1][];

    public SQLChar() {
    }

    public SQLChar(String val) {
        this.value = val;
    }

    public SQLChar(Clob val) {
        this.setValue(val);
    }

    public SQLChar(char[] val) {
        if (val == null) {
            this.value = null;
        } else {
            int length = val.length;
            char[] localCopy = new char[length];
            System.arraycopy(val, 0, localCopy, 0, length);
            this.copyState(null, localCopy, length, null, null, null, null);
        }
    }

    private static void appendBlanks(char[] ca, int offset, int howMany) {
        while (howMany > 0) {
            int count = howMany > BLANKS.length ? BLANKS.length : howMany;
            System.arraycopy(BLANKS, 0, ca, offset, count);
            howMany -= count;
            offset += count;
        }
    }

    public char[] getRawDataAndZeroIt() {
        if (this.rawData == null) {
            return null;
        }
        int length = this.rawData.length;
        char[] retval = new char[length];
        System.arraycopy(this.rawData, 0, retval, 0, length);
        this.zeroRawData();
        return retval;
    }

    public void zeroRawData() {
        if (this.rawData == null) {
            return;
        }
        Arrays.fill(this.rawData, '\u0000');
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String cleanedValue = this.getString().trim();
        return !cleanedValue.equals("0") && !cleanedValue.equals("false");
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "byte");
        }
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "short");
        }
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "int");
        }
    }

    @Override
    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "long");
        }
    }

    @Override
    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "float");
        }
    }

    @Override
    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", "double");
        }
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        return SQLChar.getDate(cal, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLDate internalDate = new SQLDate(str, false, localeFinder);
        return internalDate.getDate(cal);
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        return SQLChar.getTime(cal, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTime internalTime = new SQLTime(str, false, localeFinder, cal);
        return internalTime.getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        return SQLChar.getTimestamp(cal, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTimestamp internalTimestamp = new SQLTimestamp(str, false, localeFinder, cal);
        return internalTimestamp.getTimestamp(cal);
    }

    @Override
    public InputStream returnStream() {
        return this.stream;
    }

    @Override
    public void setStream(InputStream newStream) {
        this.value = null;
        this.rawLength = -1;
        this.stream = newStream;
        this.cKey = null;
        this._clobValue = null;
    }

    @Override
    public void loadStream() throws StandardException {
        this.getString();
    }

    @Override
    public Object getObject() throws StandardException {
        return this.getString();
    }

    @Override
    public InputStream getStream() throws StandardException {
        if (!this.hasStream()) {
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        return this.stream;
    }

    @Override
    public CharacterStreamDescriptor getStreamWithDescriptor() throws StandardException {
        throw StandardException.newException("42Z12.U", this.getTypeName());
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        return 1;
    }

    @Override
    public int getLength() throws StandardException {
        String tmpString;
        if (this._clobValue != null) {
            return this.getClobLength();
        }
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        if (this.stream != null && this.stream instanceof Resetable && this.stream instanceof ObjectInput) {
            try {
                InputStreamUtil.skipFully(this.stream, 2L);
                int n = (int)UTF8Util.skipUntilEOF(this.stream);
                return n;
            }
            catch (IOException ioe) {
                this.throwStreamingIOException(ioe);
            }
            finally {
                try {
                    ((Resetable)((Object)this.stream)).resetStream();
                }
                catch (IOException ioe) {
                    this.throwStreamingIOException(ioe);
                }
            }
        }
        if ((tmpString = this.getString()) == null) {
            return 0;
        }
        int clobLength = tmpString.length();
        return clobLength;
    }

    protected void throwStreamingIOException(IOException ioe) throws StandardException {
        throw StandardException.newException("XCL30.S", ioe, this.getTypeName());
    }

    @Override
    public String getTypeName() {
        return "CHAR";
    }

    @Override
    public String getString() throws StandardException {
        if (this.value == null) {
            int len = this.rawLength;
            if (len != -1) {
                this.value = new String(this.rawData, 0, len);
                if (len > 4096) {
                    this.rawData = null;
                    this.rawLength = -1;
                    this.cKey = null;
                }
            } else if (this._clobValue != null) {
                try {
                    this.value = this._clobValue.getSubString(1L, this.getClobLength());
                    this._clobValue = null;
                }
                catch (SQLException se) {
                    throw StandardException.plainWrapException(se);
                }
            } else if (this.stream != null) {
                try {
                    if (this.stream instanceof FormatIdInputStream) {
                        this.readExternal((FormatIdInputStream)this.stream);
                    } else {
                        this.readExternal(new FormatIdInputStream(this.stream));
                    }
                    this.stream = null;
                    return this.getString();
                }
                catch (IOException ioe) {
                    throw StandardException.newException("XCL30.S", ioe, String.class.getName());
                }
            }
        }
        return this.value;
    }

    @Override
    public char[] getCharArray() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (this.rawLength != -1) {
            return this.rawData;
        }
        this.getString();
        this.rawData = this.value.toCharArray();
        this.rawLength = this.rawData.length;
        this.cKey = null;
        return this.rawData;
    }

    @Override
    public int getTypeFormatId() {
        return 78;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawLength == -1 && this.stream == null && this._clobValue == null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isRaw;
        SanityManager.ASSERT(!this.isNull());
        if (this._clobValue != null) {
            this.writeClobUTF(out);
            return;
        }
        String lvalue = null;
        char[] data = null;
        int strlen = this.rawLength;
        if (strlen < 0) {
            lvalue = this.value;
            strlen = lvalue.length();
            isRaw = false;
        } else {
            data = this.rawData;
            isRaw = true;
        }
        int utflen = strlen;
        for (int i = 0; i < strlen && utflen <= 65535; ++i) {
            char c;
            char c2 = c = isRaw ? data[i] : lvalue.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        StreamHeaderGenerator header = this.getStreamHeaderGenerator();
        SanityManager.ASSERT(!header.expectsCharCount());
        header.generateInto(out, utflen);
        this.writeUTF(out, strlen, isRaw, null);
        header.writeEOF(out, utflen);
    }

    private final void writeUTF(ObjectOutput out, int strLen, boolean isRaw, Reader characterReader) throws IOException {
        char[] data = isRaw ? this.rawData : null;
        String lvalue = isRaw ? null : this.value;
        for (int i = 0; i < strLen; ++i) {
            int c = characterReader != null ? characterReader.read() : (isRaw ? data[i] : lvalue.charAt(i));
            SQLChar.writeUTF(out, c);
        }
    }

    private static void writeUTF(ObjectOutput out, int c) throws IOException {
        if (c >= 1 && c <= 127) {
            out.write(c);
        } else if (c > 2047) {
            out.write(0xE0 | c >> 12 & 0xF);
            out.write(0x80 | c >> 6 & 0x3F);
            out.write(0x80 | c >> 0 & 0x3F);
        } else {
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c >> 0 & 0x3F);
        }
    }

    protected final void writeClobUTF(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        SanityManager.ASSERT(this.stream == null, "Stream not null!");
        boolean isUserClob = this._clobValue != null;
        try {
            StreamHeaderGenerator header;
            boolean isRaw = this.rawLength >= 0;
            int strLen = this.rawLength;
            if (!isRaw) {
                strLen = isUserClob ? this.rawGetClobLength() : this.value.length();
            }
            int toEncodeLen = (header = this.getStreamHeaderGenerator()).expectsCharCount() ? strLen : -1;
            header.generateInto(out, toEncodeLen);
            Reader characterReader = null;
            if (isUserClob) {
                characterReader = this._clobValue.getCharacterStream();
            }
            this.writeUTF(out, strLen, isRaw, characterReader);
            header.writeEOF(out, toEncodeLen);
            if (isUserClob) {
                characterReader.close();
            }
        }
        catch (SQLException se) {
            IOException ioe = new IOException(se.getMessage());
            ioe.initCause(se);
            throw ioe;
        }
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.resetForMaterialization();
        int utfLen = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        if (this.rawData == null || this.rawData.length < utfLen) {
            this.rawData = new char[utfLen];
        }
        this.arg_passer[0] = this.rawData;
        this.rawLength = in.readDerbyUTF(this.arg_passer, utfLen);
        this.rawData = this.arg_passer[0];
    }

    protected void readExternalClobFromArray(ArrayInputStream in, int charLen) throws IOException {
        this.resetForMaterialization();
        if (this.rawData == null || this.rawData.length < charLen) {
            this.rawData = new char[charLen];
        }
        this.arg_passer[0] = this.rawData;
        this.rawLength = in.readDerbyUTF(this.arg_passer, 0);
        this.rawData = this.arg_passer[0];
    }

    private void resetForMaterialization() {
        this.value = null;
        this.stream = null;
        this.cKey = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        this.readExternal(in, utflen, 0);
    }

    protected void readExternal(ObjectInput in, int utflen, int knownStrLen) throws IOException {
        int requiredLength;
        int minGrowBy = this.growBy();
        if (utflen != 0) {
            requiredLength = utflen;
        } else {
            requiredLength = in.available();
            if (requiredLength < minGrowBy) {
                requiredLength = minGrowBy;
            }
        }
        char[] str = this.rawData == null || requiredLength > this.rawData.length ? new char[requiredLength] : this.rawData;
        int arrayLength = str.length;
        this.rawData = null;
        this.resetForMaterialization();
        int count = 0;
        int strlen = 0;
        while (!(strlen >= knownStrLen && knownStrLen != 0 || count >= utflen && utflen != 0)) {
            int char2;
            char actualChar;
            int c;
            try {
                c = in.readUnsignedByte();
            }
            catch (EOFException eof) {
                if (utflen == 0) break;
                throw new EOFException();
            }
            if (strlen >= arrayLength) {
                int growby = in.available();
                if (growby < minGrowBy) {
                    growby = minGrowBy;
                }
                int newstrlength = arrayLength + growby;
                char[] oldstr = str;
                str = new char[newstrlength];
                System.arraycopy(oldstr, 0, str, 0, arrayLength);
                arrayLength = newstrlength;
            }
            if ((c & 0x80) == 0) {
                ++count;
                actualChar = (char)c;
            } else if ((c & 0x60) == 64) {
                if (utflen != 0 && (count += 2) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
            } else if ((c & 0x70) == 96) {
                if (utflen != 0 && (count += 3) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                int char3 = in.readUnsignedByte();
                if (c == 224 && char2 == 0 && char3 == 0 && utflen == 0) break;
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
            } else {
                throw new UTFDataFormatException("Invalid code point: " + Integer.toHexString(c));
            }
            str[strlen++] = actualChar;
        }
        this.rawData = str;
        this.rawLength = strlen;
    }

    protected int growBy() {
        return 64;
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this._clobValue = null;
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(other instanceof SQLChar)) {
            return other.compare(SQLChar.flip(op), this, orderedNulls, unknownRV);
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        return this.stringCompare(this, (SQLChar)other);
    }

    @Override
    public DataValueDescriptor cloneHolder() {
        if (this.stream == null && this._clobValue == null) {
            return this.cloneValue(false);
        }
        SQLChar self = (SQLChar)this.getNewNull();
        self.copyState(this);
        return self;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLChar s = new CollatorSQLChar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.setValue(resultSet.getString(colNumber));
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setString(position, this.getString());
    }

    @Override
    public void setValue(Clob theValue) {
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
        this.value = null;
        this._clobValue = theValue;
    }

    @Override
    public void setValue(String theValue) {
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
        this._clobValue = null;
        this.value = theValue;
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        this.setValue(Boolean.toString(theValue));
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        this.setValue(Integer.toString(theValue));
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.setValue(Double.toString(theValue));
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.setValue(Float.toString(theValue));
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        this.setValue(Short.toString(theValue));
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        this.setValue(Long.toString(theValue));
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.setValue(Byte.toString(theValue));
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        if (theValue == null) {
            this.restoreToNull();
            return;
        }
        int mod = theValue.length % 2;
        int len = theValue.length / 2 + mod;
        char[] carray = new char[len];
        int cindex = 0;
        int bindex = 0;
        if (mod == 1) {
            carray[--len] = (char)(theValue[theValue.length - 1] << 8);
        }
        while (cindex < len) {
            carray[cindex] = (char)(theValue[bindex] << 8 | theValue[bindex + 1] & 0xFF);
            bindex += 2;
            ++cindex;
        }
        this.setValue(new String(carray));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        if (bigDecimal == null) {
            this.setToNull();
        } else {
            this.setValue(bigDecimal.toString());
        }
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCDate(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCTime(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuffer sb = new StringBuffer();
                this.formatJDBCDate(cal, sb);
                sb.append(' ');
                this.formatJDBCTime(cal, sb);
                sb.append('.');
                int nanos = theValue.getNanos();
                if (nanos == 0) {
                    sb.append('0');
                } else if (nanos > 0) {
                    int len;
                    String nanoString = Integer.toString(nanos);
                    for (int i = len = nanoString.length(); i < 9; ++i) {
                        sb.append('0');
                    }
                    while (nanoString.charAt(len - 1) == '0') {
                        --len;
                    }
                    sb.append(nanoString.substring(0, len));
                }
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    private void formatJDBCDate(Calendar cal, StringBuffer sb) {
        SQLDate.dateToString(cal.get(1), cal.get(2) - 0 + 1, cal.get(5), sb);
    }

    private void formatJDBCTime(Calendar cal, StringBuffer sb) {
        SQLTime.timeToString(cal.get(11), cal.get(12), cal.get(13), sb);
    }

    @Override
    public final void setValue(InputStream theStream, int valueLength) {
        this.setStream(theStream);
    }

    @Override
    public void setObjectForCast(Object theValue, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        if (theValue == null) {
            this.setToNull();
            return;
        }
        if ("java.lang.String".equals(resultTypeClassName)) {
            this.setValue(theValue.toString());
        } else {
            super.setObjectForCast(theValue, instanceOfResultType, resultTypeClassName);
        }
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLChar) {
            SQLChar that = (SQLChar)theValue;
            if (that._clobValue != null) {
                this.setValue(that._clobValue);
                return;
            }
        }
        this.setValue(theValue.getString());
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth == desiredWidth) {
            this.setValue(sourceValue);
            return;
        }
        if (sourceWidth < desiredWidth) {
            char[] ca;
            this.setToNull();
            if (this.rawData == null || desiredWidth > this.rawData.length) {
                this.rawData = new char[desiredWidth];
                ca = this.rawData;
            } else {
                ca = this.rawData;
            }
            sourceValue.getChars(0, sourceWidth, ca, 0);
            SQLChar.appendBlanks(ca, sourceWidth, desiredWidth - sourceWidth);
            this.rawLength = desiredWidth;
            return;
        }
        this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
        String truncatedString = sourceValue.substring(0, desiredWidth);
        this.setValue(truncatedString);
    }

    protected final void hasNonBlankChars(String source, int start, int end) throws StandardException {
        for (int posn = start; posn < end; ++posn) {
            if (source.charAt(posn) == ' ') continue;
            throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(source), String.valueOf(start));
        }
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this._clobValue == null && this.getString() == null) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth < desiredWidth) {
            if (!(this instanceof SQLVarchar)) {
                StringBuffer strbuf = new StringBuffer(this.getString());
                while (sourceWidth < desiredWidth) {
                    strbuf.append(' ');
                    ++sourceWidth;
                }
                this.setValue(new String(strbuf));
            }
        } else if (sourceWidth > desiredWidth && desiredWidth > 0) {
            try {
                this.hasNonBlankChars(this.getString(), desiredWidth, sourceWidth);
            }
            catch (StandardException se) {
                if (errorOnTrunc) {
                    throw se;
                }
                String source = this.getString();
                int transferSize = this.getUTF8Length(source, 0, desiredWidth);
                int dataSize = transferSize + this.getUTF8Length(source, desiredWidth, source.length());
                DataTruncation warning = new DataTruncation(-1, false, true, dataSize, transferSize);
                warning.initCause(se);
                StatementContext statementContext = (StatementContext)DataValueFactoryImpl.getContext("StatementContext");
                statementContext.getActivation().getResultSet().addWarning(warning);
            }
            this.setValue(this.getString().substring(0, desiredWidth));
        }
    }

    private int getUTF8Length(String string, int start, int end) throws StandardException {
        CounterOutputStream cs = new CounterOutputStream();
        try {
            FormatIdOutputStream out = new FormatIdOutputStream(cs);
            for (int i = start; i < end; ++i) {
                SQLChar.writeUTF(out, string.charAt(i));
            }
            out.close();
        }
        catch (IOException ioe) {
            throw StandardException.newException("X0X63.S", ioe, ioe.toString());
        }
        return cs.getCount();
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) == 0 : SQLChar.stringCompare(left.getString(), right.getString()) == 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) != 0 : SQLChar.stringCompare(left.getString(), right.getString()) != 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) < 0 : SQLChar.stringCompare(left.getString(), right.getString()) < 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) > 0 : SQLChar.stringCompare(left.getString(), right.getString()) > 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) <= 0 : SQLChar.stringCompare(left.getString(), right.getString()) <= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) >= 0 : SQLChar.stringCompare(left.getString(), right.getString()) >= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public NumberDataValue charLength(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setValue(this.getLength());
        return result;
    }

    @Override
    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (leftOperand.isNull() || leftOperand.getString() == null || rightOperand.isNull() || rightOperand.getString() == null) {
            result.setToNull();
            return result;
        }
        result.setValue(leftOperand.getString().concat(rightOperand.getString()));
        return result;
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor pattern) throws StandardException {
        char[] evalCharArray = this.getCharArray();
        char[] patternCharArray = ((SQLChar)pattern).getCharArray();
        Boolean likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor pattern, DataValueDescriptor escape) throws StandardException {
        SanityManager.ASSERT(pattern instanceof StringDataValue && escape instanceof StringDataValue, "All three operands must be instances of StringDataValue");
        if (escape.isNull()) {
            throw StandardException.newException("22501", new Object[0]);
        }
        char[] evalCharArray = this.getCharArray();
        char[] patternCharArray = ((SQLChar)pattern).getCharArray();
        char[] escapeCharArray = ((SQLChar)escape).getCharArray();
        int escapeLength = escape.getLength();
        if (escapeCharArray != null && escapeLength != 1) {
            throw StandardException.newException("22019", new String(escapeCharArray));
        }
        Boolean likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), escapeCharArray, escapeLength, null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    @Override
    public NumberDataValue locate(StringDataValue searchFrom, NumberDataValue start, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        int startVal = start.isNull() ? 1 : start.getInt();
        if (this.isNull() || searchFrom.isNull()) {
            result.setToNull();
            return result;
        }
        String mySearchFrom = searchFrom.getString();
        String mySearchFor = this.getString();
        if (startVal < 1) {
            throw StandardException.newException("22014", this.getString(), mySearchFrom, startVal);
        }
        if (mySearchFor.length() == 0) {
            result.setValue(startVal);
            return result;
        }
        result.setValue(mySearchFrom.indexOf(mySearchFor, startVal - 1) + 1);
        return result;
    }

    @Override
    public ConcatableDataValue substring(NumberDataValue start, NumberDataValue length, ConcatableDataValue result, int maxLen) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        StringDataValue stringResult = (StringDataValue)result;
        if (this.isNull() || start.isNull() || length != null && length.isNull()) {
            stringResult.setToNull();
            return stringResult;
        }
        int startInt = start.getInt();
        int lengthInt = length != null ? length.getInt() : maxLen - startInt + 1;
        if (startInt <= 0 || lengthInt < 0 || startInt > maxLen || lengthInt > maxLen - startInt + 1) {
            throw StandardException.newException("22011", new Object[0]);
        }
        if (lengthInt < 0) {
            stringResult.setToNull();
            return stringResult;
        }
        if (startInt < 0) {
            if (startInt + this.getLength() < 0 && startInt + this.getLength() + lengthInt <= 0) {
                stringResult.setValue("");
                return stringResult;
            }
            startInt += this.getLength();
            while (startInt < 0) {
                ++startInt;
                --lengthInt;
            }
        } else if (startInt > 0) {
            --startInt;
        }
        if (lengthInt == 0 || lengthInt <= 0 - startInt || startInt > this.getLength()) {
            stringResult.setValue("");
            return stringResult;
        }
        if (lengthInt >= this.getLength() - startInt) {
            stringResult.setValue(this.getString().substring(startInt));
        } else {
            stringResult.setValue(this.getString().substring(startInt, startInt + lengthInt));
        }
        return stringResult;
    }

    private String trimInternal(int trimType, char trimChar, String source) {
        int end;
        int start;
        if (source == null) {
            return null;
        }
        int len = source.length();
        if (trimType == 2 || trimType == 0) {
            for (start = 0; start < len && trimChar == source.charAt(start); ++start) {
            }
        }
        if (start == len) {
            return "";
        }
        if (trimType == 1 || trimType == 0) {
            for (end = len - 1; end >= 0 && trimChar == source.charAt(end); --end) {
            }
        }
        if (end == -1) {
            return "";
        }
        return source.substring(start, end + 1);
    }

    @Override
    public StringDataValue ansiTrim(int trimType, StringDataValue trimChar, StringDataValue result) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        if (trimChar == null || trimChar.getString() == null) {
            result.setToNull();
            return result;
        }
        if (trimChar.getString().length() != 1) {
            throw StandardException.newException("22020", trimChar.getString());
        }
        char trimCharacter = trimChar.getString().charAt(0);
        result.setValue(this.trimInternal(trimType, trimCharacter, this.getString()));
        return result;
    }

    @Override
    public StringDataValue upper(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String upper = this.getString();
        upper = upper.toUpperCase(this.getLocale());
        result.setValue(upper);
        return result;
    }

    @Override
    public StringDataValue lower(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String lower = this.getString();
        lower = lower.toLowerCase(this.getLocale());
        result.setValue(lower);
        return result;
    }

    @Override
    public int typePrecedence() {
        return 0;
    }

    protected static int stringCompare(String op1, String op2) {
        int remainingLen;
        String remainingString;
        int retvalIfLTSpace;
        int posn;
        int rightlen;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int leftlen = op1.length();
        int shorterLen = leftlen < (rightlen = op2.length()) ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char rightchar;
            char leftchar = op1.charAt(posn);
            if (leftchar == (rightchar = op2.charAt(posn))) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString.charAt(posn);
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected int stringCompare(SQLChar char1, SQLChar char2) throws StandardException {
        return SQLChar.stringCompare(char1.getCharArray(), char1.getLength(), char2.getCharArray(), char2.getLength());
    }

    protected static int stringCompare(char[] op1, int leftlen, char[] op2, int rightlen) {
        int remainingLen;
        char[] remainingString;
        int retvalIfLTSpace;
        int posn;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int shorterLen = leftlen < rightlen ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char leftchar = op1[posn];
            char rightchar = op2[posn];
            if (leftchar == rightchar) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString[posn];
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected CollationKey getCollationKey() throws StandardException {
        int lastNonspaceChar;
        char[] tmpCharArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (tmpCharArray = this.getCharArray()) == null) {
            return null;
        }
        for (lastNonspaceChar = this.rawLength; lastNonspaceChar > 0 && this.rawData[lastNonspaceChar - 1] == ' '; --lastNonspaceChar) {
        }
        RuleBasedCollator rbc = this.getCollatorForCollation();
        this.cKey = rbc.getCollationKey(new String(this.rawData, 0, lastNonspaceChar));
        return this.cKey;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value == null && this.rawLength != -1) {
            return new String(this.rawData, 0, this.rawLength);
        }
        if (this.stream != null) {
            try {
                return this.getString();
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        int lastNonPadChar;
        SanityManager.ASSERT(!(this instanceof CollationElementsInterface), "SQLChar.hashCode() does not work with collation");
        try {
            if (this.getString() == null) {
                return 0;
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return 0;
        }
        String lvalue = this.value;
        for (lastNonPadChar = lvalue.length() - 1; lastNonPadChar >= 0 && lvalue.charAt(lastNonPadChar) == ' '; --lastNonPadChar) {
        }
        int hashcode = 0;
        for (int i = 0; i <= lastNonPadChar; ++i) {
            hashcode = hashcode * 31 + lvalue.charAt(i);
        }
        return hashcode;
    }

    int hashCodeForCollation() {
        CollationKey key = null;
        try {
            key = this.getCollationKey();
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
        }
        return key == null ? 0 : key.hashCode();
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    protected void setLocaleFinder(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected RuleBasedCollator getCollatorForCollation() throws StandardException {
        SanityManager.THROWASSERT("No support for collators in base class");
        return null;
    }

    protected LocaleFinder getLocaleFinder() {
        DatabaseContext dc;
        if (this.localeFinder == null && (dc = (DatabaseContext)DataValueFactoryImpl.getContext("Database")) != null) {
            this.localeFinder = dc.getDatabase();
        }
        return this.localeFinder;
    }

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (null != this.rawData) {
            sz += 2 * this.rawData.length;
        }
        return sz;
    }

    protected void copyState(SQLChar other) {
        this.copyState(other.value, other.rawData, other.rawLength, other.cKey, other.stream, other._clobValue, other.localeFinder);
    }

    private void copyState(String otherValue, char[] otherRawData, int otherRawLength, CollationKey otherCKey, InputStream otherStream, Clob otherClobValue, LocaleFinder otherLocaleFinder) {
        this.value = otherValue;
        this.rawData = otherRawData;
        this.rawLength = otherRawLength;
        this.cKey = otherCKey;
        this.stream = otherStream;
        this._clobValue = otherClobValue;
        this.localeFinder = otherLocaleFinder;
    }

    @Override
    public String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        return this.toString();
    }

    @Override
    public StreamHeaderGenerator getStreamHeaderGenerator() {
        return CHAR_HEADER_GENERATOR;
    }

    @Override
    public void setStreamHeaderFormat(Boolean inSoftUpgradeMode) {
    }

    private int getClobLength() throws StandardException {
        try {
            return this.rawGetClobLength();
        }
        catch (SQLException se) {
            throw StandardException.plainWrapException(se);
        }
    }

    private int rawGetClobLength() throws SQLException {
        long maxLength = Integer.MAX_VALUE;
        long length = this._clobValue.length();
        if (length > Integer.MAX_VALUE) {
            StandardException se = StandardException.newException("XJ093.S", Long.toString(length), Long.toString(maxLength));
            throw new SQLException(se.getMessage());
        }
        return (int)length;
    }

    static {
        for (int i = 0; i < BLANKS.length; ++i) {
            SQLChar.BLANKS[i] = 32;
        }
        CHAR_HEADER_GENERATOR = new CharStreamHeaderGenerator();
    }
}

