/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;

public final class StatementGenericPermission
extends StatementPermission {
    private UUID _objectID;
    private String _objectType;
    private String _privilege;

    public StatementGenericPermission(UUID objectID, String objectType, String privilege) {
        this._objectID = objectID;
        this._objectType = objectType;
        this._privilege = privilege;
    }

    public UUID getObjectID() {
        return this._objectID;
    }

    public String getPrivilege() {
        return this._privilege;
    }

    @Override
    public String getObjectType() {
        return this._objectType;
    }

    @Override
    public void check(LanguageConnectionContext lcc, boolean forGrant, Activation activation) throws StandardException {
        this.genericCheck(lcc, forGrant, activation, this._privilege);
    }

    @Override
    public boolean isCorrectPermission(PermissionsDescriptor raw) {
        if (raw == null || !(raw instanceof PermDescriptor)) {
            return false;
        }
        PermDescriptor pd = (PermDescriptor)raw;
        return pd.getPermObjectId().equals(this._objectID) && pd.getObjectType().equals(this._objectType) && pd.getPermission().equals(this._privilege);
    }

    @Override
    public PrivilegedSQLObject getPrivilegedObject(DataDictionary dd) throws StandardException {
        if ("TYPE".equals(this._objectType)) {
            return dd.getAliasDescriptor(this._objectID);
        }
        if ("DERBY AGGREGATE".equals(this._objectType)) {
            return dd.getAliasDescriptor(this._objectID);
        }
        if ("SEQUENCE".equals(this._objectType)) {
            return dd.getSequenceDescriptor(this._objectID);
        }
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return dd.getGenericPermissions(this._objectID, this._objectType, this._privilege, authid);
    }

    public String toString() {
        return "StatementGenericPermission( " + this._objectID + ", " + this._objectType + ", " + this._privilege + " )";
    }
}

