/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.derby.iapi.error.SQLWarningFactory;
import org.apache.derby.iapi.jdbc.BrokeredCallableStatement;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ExceptionFactory;
import org.apache.derby.iapi.jdbc.FailedProperties40;

public class BrokeredConnection
implements EngineConnection {
    int stateHoldability = 1;
    final BrokeredConnectionControl control;
    protected boolean isClosed;
    private String connString;
    private int stateIsolationLevel;
    private boolean stateReadOnly;
    private boolean stateAutoCommit;

    public BrokeredConnection(BrokeredConnectionControl control) throws SQLException {
        this.control = control;
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.control.checkAutoCommit(autoCommit);
            this.getRealConnection().setAutoCommit(autoCommit);
            this.stateAutoCommit = autoCommit;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        try {
            return this.getRealConnection().getAutoCommit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Statement createStatement() throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement());
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql), sql, null);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql), sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final String nativeSQL(String sql) throws SQLException {
        try {
            return this.getRealConnection().nativeSQL(sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void commit() throws SQLException {
        try {
            this.control.checkCommit();
            this.getRealConnection().commit();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void rollback() throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.control.checkClose();
            if (!this.control.closingConnection()) {
                this.isClosed = true;
                return;
            }
            this.isClosed = true;
            this.getRealConnection().close();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            boolean realIsClosed = this.getRealConnection().isClosed();
            if (realIsClosed) {
                this.control.closingConnection();
                this.isClosed = true;
            }
            return realIsClosed;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealConnection().getWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        try {
            this.getRealConnection().clearWarnings();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getRealConnection().getMetaData();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.getRealConnection().setReadOnly(readOnly);
            this.stateReadOnly = readOnly;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        try {
            return this.getRealConnection().isReadOnly();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        try {
            this.getRealConnection().setCatalog(catalog);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final String getCatalog() throws SQLException {
        try {
            return this.getRealConnection().getCatalog();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        try {
            this.getRealConnection().setTransactionIsolation(level);
            this.stateIsolationLevel = level;
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        try {
            return this.getRealConnection().getTransactionIsolation();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            return this.getRealConnection().getTypeMap();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.getRealConnection().setTypeMap(map);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.control.checkSavepoint();
            return this.getRealConnection().setSavepoint(name);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.control.checkRollback();
            this.getRealConnection().rollback(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.getRealConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
        try {
            holdability = this.control.checkHoldCursors(holdability, false);
            this.getRealConnection().setHoldability(holdability);
            this.stateHoldability = holdability;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, autoGeneratedKeys), sql, autoGeneratedKeys);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnIndexes), sql, columnIndexes);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, columnNames), sql, columnNames);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    final SQLException noCurrentConnection() {
        return ExceptionFactory.getInstance().getSQLException("08003", null, null, null);
    }

    final EngineConnection getRealConnection() throws SQLException {
        if (this.isClosed) {
            throw this.noCurrentConnection();
        }
        return this.control.getRealConnection();
    }

    final void notifyException(SQLException sqle) {
        if (!this.isClosed) {
            this.control.notifyException(sqle);
        }
    }

    public void syncState() throws SQLException {
        EngineConnection conn = this.getRealConnection();
        this.stateIsolationLevel = conn.getTransactionIsolation();
        this.stateReadOnly = conn.isReadOnly();
        this.stateAutoCommit = conn.getAutoCommit();
        this.stateHoldability = conn.getHoldability();
    }

    public void getIsolationUptoDate() throws SQLException {
        if (this.control.isIsolationLevelSetUsingSQLorJDBC()) {
            this.stateIsolationLevel = this.getRealConnection().getTransactionIsolation();
            this.control.resetIsolationLevelFlag();
        }
    }

    public void setState(boolean complete) throws SQLException {
        if (complete) {
            EngineConnection conn = this.getRealConnection();
            conn.setTransactionIsolation(this.stateIsolationLevel);
            conn.setReadOnly(this.stateReadOnly);
            conn.setAutoCommit(this.stateAutoCommit);
            conn.setHoldability(this.stateHoldability);
        }
    }

    public final BrokeredStatement newBrokeredStatement(BrokeredStatementControl statementControl) throws SQLException {
        try {
            return new BrokeredStatement(statementControl);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public BrokeredPreparedStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql, Object generatedKeys) throws SQLException {
        try {
            return new BrokeredPreparedStatement(statementControl, sql, generatedKeys);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    public BrokeredCallableStatement newBrokeredStatement(BrokeredStatementControl statementControl, String sql) throws SQLException {
        try {
            return new BrokeredCallableStatement(statementControl, sql);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setDrdaID(String drdaID) {
        try {
            this.getRealConnection().setDrdaID(drdaID);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInGlobalTransaction() {
        return this.control.isInGlobalTransaction();
    }

    @Override
    public final void setPrepareIsolation(int level) throws SQLException {
        this.getRealConnection().setPrepareIsolation(level);
    }

    @Override
    public final int getPrepareIsolation() throws SQLException {
        return this.getRealConnection().getPrepareIsolation();
    }

    @Override
    public final void addWarning(SQLWarning w) throws SQLException {
        this.getRealConnection().addWarning(w);
    }

    public String toString() {
        if (this.connString == null) {
            String wrappedString;
            try {
                wrappedString = this.getRealConnection().toString();
            }
            catch (SQLException e) {
                wrappedString = "<none>";
            }
            this.connString = this.getClass().getName() + "@" + this.hashCode() + ", Wrapped Connection = " + wrappedString;
        }
        return this.connString;
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            resultSetHoldability = this.statementHoldabilityCheck(resultSetHoldability);
            return this.control.wrapStatement(this.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, null);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final int getHoldability() throws SQLException {
        try {
            return this.getRealConnection().getHoldability();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.getRealConnection().createArrayOf(typeName, elements);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Blob createBlob() throws SQLException {
        try {
            return this.getRealConnection().createBlob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Clob createClob() throws SQLException {
        try {
            return this.getRealConnection().createClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final NClob createNClob() throws SQLException {
        try {
            return this.getRealConnection().createNClob();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final SQLXML createSQLXML() throws SQLException {
        try {
            return this.getRealConnection().createSQLXML();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            return this.getRealConnection().createStruct(typeName, attributes);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        try {
            return this.getRealConnection().isValid(timeout);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(name, value);
        }
        catch (SQLClientInfoException se) {
            this.notifyException(se);
            throw se;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(name, value)).getProperties());
        }
    }

    @Override
    public final void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getRealConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException cie) {
            this.notifyException(cie);
            throw cie;
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw new SQLClientInfoException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public final String getClientInfo(String name) throws SQLException {
        try {
            return this.getRealConnection().getClientInfo(name);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final Properties getClientInfo() throws SQLException {
        try {
            return this.getRealConnection().getClientInfo();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw this.noCurrentConnection();
            }
            return iface.isInstance(this);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.getRealConnection().isClosed()) {
                throw this.noCurrentConnection();
            }
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw ExceptionFactory.getInstance().getSQLException("XJ128.S", (SQLException)null, (Throwable)null, iface);
            }
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    final int statementHoldabilityCheck(int resultSetHoldability) throws SQLException {
        int holdability = this.control.checkHoldCursors(resultSetHoldability, true);
        if (holdability != resultSetHoldability) {
            SQLWarning w = SQLWarningFactory.newSQLWarning("01J07", new Object[0]);
            this.addWarning(w);
        }
        return holdability;
    }

    @Override
    public Object getLOBMapping(int key) throws SQLException {
        return this.getRealConnection().getLOBMapping(key);
    }

    @Override
    public String getCurrentSchemaName() throws SQLException {
        try {
            return this.getRealConnection().getCurrentSchemaName();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public void resetFromPool() throws SQLException {
        this.getRealConnection().resetFromPool();
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.getRealConnection().getSchema();
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public void setSchema(String schemaName) throws SQLException {
        try {
            this.getRealConnection().setSchema(schemaName);
        }
        catch (SQLException se) {
            this.notifyException(se);
            throw se;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (!this.isClosed) {
            this.getRealConnection().abort(executor);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.getRealConnection().getNetworkTimeout();
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.getRealConnection().setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException sqle) {
            this.notifyException(sqle);
            throw sqle;
        }
    }
}

