/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import os.shaded_org_apache_tools_zip.ZipExtraField;
import os.shaded_org_apache_tools_zip.ZipLong;
import os.shaded_org_apache_tools_zip.ZipShort;

public abstract class AbstractUnicodeExtraField
implements ZipExtraField {
    private long nameCRC32;
    private byte[] unicodeName;
    private byte[] data;

    protected AbstractUnicodeExtraField() {
    }

    protected AbstractUnicodeExtraField(String string, byte[] byArray, int n, int n2) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        this.nameCRC32 = cRC32.getValue();
        this.unicodeName = string.getBytes(StandardCharsets.UTF_8);
    }

    protected AbstractUnicodeExtraField(String string, byte[] byArray) {
        this(string, byArray, 0, byArray.length);
    }

    private void assembleData() {
        if (this.unicodeName == null) {
            return;
        }
        this.data = new byte[5 + this.unicodeName.length];
        this.data[0] = 1;
        System.arraycopy(ZipLong.getBytes(this.nameCRC32), 0, this.data, 1, 4);
        System.arraycopy(this.unicodeName, 0, this.data, 5, this.unicodeName.length);
    }

    public long getNameCRC32() {
        return this.nameCRC32;
    }

    public void setNameCRC32(long l) {
        this.nameCRC32 = l;
        this.data = null;
    }

    public byte[] getUnicodeName() {
        byte[] byArray = null;
        if (this.unicodeName != null) {
            byArray = new byte[this.unicodeName.length];
            System.arraycopy(this.unicodeName, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    public void setUnicodeName(byte[] byArray) {
        if (byArray != null) {
            this.unicodeName = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.unicodeName, 0, byArray.length);
        } else {
            this.unicodeName = null;
        }
        this.data = null;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        if (this.data == null) {
            this.assembleData();
        }
        byte[] byArray = null;
        if (this.data != null) {
            byArray = new byte[this.data.length];
            System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        }
        return byArray;
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        if (this.data == null) {
            this.assembleData();
        }
        return new ZipShort(this.data.length);
    }

    @Override
    public byte[] getLocalFileDataData() {
        return this.getCentralDirectoryData();
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return this.getCentralDirectoryLength();
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n, int n2) throws ZipException {
        if (n2 < 5) {
            throw new ZipException("UniCode path extra data must have at least 5 bytes.");
        }
        byte by = byArray[n];
        if (by != 1) {
            throw new ZipException("Unsupported version [" + by + "] for UniCode path extra data.");
        }
        this.nameCRC32 = ZipLong.getValue(byArray, n + 1);
        this.unicodeName = new byte[n2 - 5];
        System.arraycopy(byArray, n + 5, this.unicodeName, 0, n2 - 5);
        this.data = null;
    }
}

