/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Int$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.RichDouble$;

public interface TextDecimalVirtualPointMixin {
    public static void $init$(TextDecimalVirtualPointMixin $this) {
    }

    public int textDecimalVirtualPoint();

    public static double virtualPointScaleFactor$(TextDecimalVirtualPointMixin $this) {
        return $this.virtualPointScaleFactor();
    }

    default public double virtualPointScaleFactor() {
        return package$.MODULE$.pow(10.0, Int$.MODULE$.int2double(this.textDecimalVirtualPoint()));
    }

    public static Number applyTextDecimalVirtualPointForParse$(TextDecimalVirtualPointMixin $this, Number num) {
        return $this.applyTextDecimalVirtualPointForParse(num);
    }

    default public Number applyTextDecimalVirtualPointForParse(Number num) {
        Number number;
        if (this.textDecimalVirtualPoint() == 0) {
            return num;
        }
        Number number2 = num;
        if (number2 instanceof Long) {
            Long l = (Long)number2;
            BigDecimal scaled = BigDecimal.valueOf(Predef$.MODULE$.Long2long(l)).scaleByPowerOfTen(-this.textDecimalVirtualPoint());
            number = this.textDecimalVirtualPoint() < 0 ? scaled.toBigIntegerExact() : scaled;
        } else if (number2 instanceof BigInteger) {
            BigInteger bi = (BigInteger)number2;
            BigDecimal bd = new BigDecimal(bi);
            number = bd.scaleByPowerOfTen(-this.textDecimalVirtualPoint());
        } else if (number2 instanceof Double) {
            Double d = (Double)number2;
            if (!d.isNaN() && !d.isInfinite() && Double.doubleToLongBits(Predef$.MODULE$.Double2double(d)) != Long.MIN_VALUE) {
                throw Assert$.MODULE$.abort("Invariant broken: d.isNaN().||(d.isInfinite()).||(java.lang.Double.doubleToLongBits(scala.Predef.Double2double(d)).==(-9223372036854775808L))");
            }
            number = d;
        } else {
            throw Assert$.MODULE$.invariantFailed(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |Number cannot be scaled for virtual decimal point,\n            |expected integer type but got " + num.getClass().getSimpleName() + ".\n            ")));
        }
        Number scaledNum = number;
        return scaledNum;
    }

    public static Number applyTextDecimalVirtualPointForUnparse$(TextDecimalVirtualPointMixin $this, Number value) {
        return $this.applyTextDecimalVirtualPointForUnparse(value);
    }

    /*
     * Unable to fully structure code
     */
    default public Number applyTextDecimalVirtualPointForUnparse(Number value) {
        var3_2 = value;
        if (var3_2 == null) ** GOTO lbl-1000
        jn = var3_2;
        if (this.textDecimalVirtualPoint() == 0) {
            v0 = jn;
        } else if (var3_2 instanceof Float) {
            var5_4 = (Float)var3_2;
            f = var5_4;
            if (f.isNaN() || f.isInfinite()) {
                v0 = f;
            } else {
                f = var5_4;
                v0 = Predef$.MODULE$.float2Float((float)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)Predef$.MODULE$.Float2float(f) * this.virtualPointScaleFactor())));
            }
        } else if (var3_2 instanceof Double) {
            var8_7 = (Double)var3_2;
            d = var8_7;
            if (d.isNaN() || d.isInfinite()) {
                v0 = d;
            } else {
                d = var8_7;
                v0 = Predef$.MODULE$.double2Double((double)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(Predef$.MODULE$.Double2double(d) * this.virtualPointScaleFactor())));
            }
        } else if (var3_2 instanceof BigDecimal) {
            bd = (BigDecimal)var3_2;
            v0 = bd.scaleByPowerOfTen(this.textDecimalVirtualPoint()).round(MathContext.UNLIMITED);
        } else {
            throw Assert$.MODULE$.invariantFailed(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Number cannot be unscaled for virtual decimal point,\n          |expected decimal, float, or double, but got\n          |" + value.getClass().getSimpleName() + ".")));
        }
        res = v0;
        v1 = res.getClass();
        var12_12 = value.getClass();
        if (v1 == null ? var12_12 != null : v1.equals(var12_12) == false) {
            throw Assert$.MODULE$.abort("Invariant broken: res.getClass[java.lang.Number]().==(value.getClass[java.lang.Number]())");
        }
        return res;
    }
}

