/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.List;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.ParseResult;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.core.compiler.Compiler;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.core.dsom.Root;
import org.apache.daffodil.core.dsom.SchemaSet;
import org.apache.daffodil.core.dsom.SchemaSet$;
import org.apache.daffodil.core.util.TestUtils;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.lib.exceptions.MultiException;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.SchemaUtils$;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter$;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.UnparseResult;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class TestUtils$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TestUtils$.class.getDeclaredField("builtInTracer$lzy1"));
    private volatile Object builtInTracer$lzy1;
    private static final Elem defaultIncludeImports;
    private static final Elem defaultTopLevels;
    public static final TestUtils$ MODULE$;

    private TestUtils$() {
    }

    static {
        MODULE$ = new TestUtils$();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("schemaLocation", (Seq)new Text("/org/apache/daffodil/xsd/DFDLGeneralFormat.dfdl.xsd"), (MetaData)$md);
        defaultIncludeImports = new Elem("xs", "include", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("encoding", (Seq)new Text("US-ASCII"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("lengthKind", (Seq)new Text("delimited"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("ref", (Seq)new Text("tns:GeneralFormat"), (MetaData)$md2);
        defaultTopLevels = new Elem("dfdl", "format", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TestUtils$.class);
    }

    public <T> T intercept(Function0<Object> body, ClassTag<T> tag) {
        None$ caught;
        None$ none$;
        Class clazz = tag.runtimeClass();
        try {
            body.apply();
            none$ = None$.MODULE$;
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (ControlThrowable s) {
            throw s;
        }
        catch (Throwable u) {
            if (!clazz.isAssignableFrom(u.getClass())) {
                throw new TestUtils.InterceptFailedException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to intercept expected exception. Expected '%s' but got '%s'."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName(), u.getClass().getName()})));
            }
            none$ = Some$.MODULE$.apply((Object)u);
        }
        None$ none$2 = caught = none$;
        if (None$.MODULE$.equals(none$2)) {
            throw new TestUtils.InterceptFailedException("Failed to intercept any exceptions.");
        }
        if (none$2 instanceof Some) {
            Throwable e = (Throwable)((Some)none$2).value();
            return (T)e;
        }
        throw new MatchError((Object)none$2);
    }

    public <T> void assertEquals(T expected, T actual) {
        if (!BoxesRunTime.equals(expected, actual)) {
            throw new AssertionError((Object)"assertEquals failed.");
        }
    }

    public Tuple2<ParseResult, Node> testString(Node testSchema, String data, boolean areTracing) {
        return this.runSchemaOnRBC(testSchema, Misc$.MODULE$.stringToReadableByteChannel(data), areTracing);
    }

    public boolean testString$default$3() {
        return false;
    }

    public Tuple2<ParseResult, Node> testBinary(Node testSchema, String hexData, boolean areTracing) {
        byte[] b = Misc$.MODULE$.hex2Bytes(hexData);
        return this.testBinary(testSchema, b, areTracing);
    }

    public boolean testBinary$default$3() {
        return false;
    }

    public Tuple2<ParseResult, Node> testBinary(Node testSchema, byte[] data, boolean areTracing) {
        ReadableByteChannel rbc = Misc$.MODULE$.byteArrayToReadableByteChannel(data);
        return this.runSchemaOnRBC(testSchema, rbc, areTracing);
    }

    public List<Diagnostic> testUnparsing(Elem testSchema, Node infosetXML, String unparseTo, boolean areTracing) {
        ByteArrayOutputStream outputStream;
        WritableByteChannel out;
        ScalaXMLInfosetInputter inputter;
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunable("allowExternalPathExpressions", "true");
        ProcessorFactory pf = compiler.compileNode((Node)testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.getDiagnostics());
        }
        DataProcessor u = this.saveAndReload((DataProcessor)pf.onPath("/"));
        if (u.isError()) {
            throw this.throwDiagnostics(u.getDiagnostics());
        }
        u = areTracing ? u.withDebugger(this.builtInTracer()) : u;
        UnparseResult actual = u.unparse((InfosetInputter)(inputter = new ScalaXMLInfosetInputter(infosetXML)), out = Channels.newChannel(outputStream = new ByteArrayOutputStream()));
        if (actual.isProcessingError()) {
            throw this.throwDiagnostics(actual.getDiagnostics());
        }
        String unparsed = outputStream.toString();
        out.close();
        this.assertEquals(unparseTo, unparsed);
        return actual.getDiagnostics();
    }

    public boolean testUnparsing$default$4() {
        return false;
    }

    private Nothing$ throwDiagnostics(List<Diagnostic> ds) {
        return new MultiException<Diagnostic>(ds).toss();
    }

    public void testUnparsingBinary(Elem testSchema, Node infoset, byte[] unparseTo, boolean areTracing) {
        ByteArrayOutputStream outputStream;
        WritableByteChannel out;
        ScalaXMLInfosetInputter inputter;
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
        ProcessorFactory pf = compiler.compileNode((Node)testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.getDiagnostics());
        }
        DataProcessor u = (DataProcessor)pf.onPath("/");
        if (u.isError()) {
            throw this.throwDiagnostics(u.getDiagnostics());
        }
        u = areTracing ? u.withDebugger(this.builtInTracer()) : u;
        UnparseResult actual = u.unparse((InfosetInputter)(inputter = new ScalaXMLInfosetInputter(infoset)), out = Channels.newChannel(outputStream = new ByteArrayOutputStream()));
        if (actual.isProcessingError()) {
            throw this.throwDiagnostics(actual.getDiagnostics());
        }
        byte[] unparsed = outputStream.toByteArray();
        out.close();
        this.assertEquals(BoxesRunTime.boxToInteger((int)unparsed.length), BoxesRunTime.boxToInteger((int)unparseTo.length));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), unparsed.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> MODULE$.assertEquals(BoxesRunTime.boxToByte((byte)unparseTo[i]), BoxesRunTime.boxToByte((byte)unparsed[i])));
    }

    public boolean testUnparsingBinary$default$4() {
        return false;
    }

    private Debugger builtInTracer() {
        Object object = this.builtInTracer$lzy1;
        if (object instanceof Debugger) {
            return (Debugger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Debugger)this.builtInTracer$lzyINIT1();
    }

    private Object builtInTracer$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builtInTracer$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Debugger debugger = null;
                    try {
                        debugger = Daffodil.newTraceDebugger(System.out);
                        object2 = debugger == null ? LazyVals.NullValue$.MODULE$ : debugger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builtInTracer$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return debugger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private DataProcessor saveAndReload(DataProcessor p) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WritableByteChannel output = Channels.newChannel(os);
        p.save(output);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        ReadableByteChannel input = Channels.newChannel(is);
        Compiler compiler_ = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
        return (DataProcessor)compiler_.reload(input);
    }

    public DataProcessor compileSchema(Node testSchema) {
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
        ProcessorFactory pf = compiler.compileNode(testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.getDiagnostics());
        }
        DataProcessor p = this.saveAndReload((DataProcessor)pf.onPath("/"));
        if (p.isError()) {
            throw this.throwDiagnostics(p.getDiagnostics());
        }
        return p;
    }

    private Tuple2<ParseResult, Node> runSchemaOnRBC(Node testSchema, ReadableByteChannel data, boolean areTracing) {
        return this.runSchemaOnInputStream(testSchema, Channels.newInputStream(data), areTracing);
    }

    private boolean runSchemaOnRBC$default$3() {
        return false;
    }

    private Tuple2<ParseResult, Node> runSchemaOnInputStream(Node testSchema, InputStream is, boolean areTracing) {
        DataProcessor p = this.compileSchema(testSchema);
        return this.runDataProcessorOnInputStream(p, is, areTracing);
    }

    private boolean runSchemaOnInputStream$default$3() {
        return false;
    }

    public Tuple2<ParseResult, Node> runDataProcessorOnInputStream(DataProcessor dp, InputStream is, boolean areTracing) {
        DataProcessor p1 = areTracing ? dp.withDebugger(this.builtInTracer()) : dp;
        org.apache.daffodil.api.DataProcessor p = p1.withValidation("daffodil");
        ScalaXMLInfosetOutputter outputter = new ScalaXMLInfosetOutputter(ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1());
        InputSourceDataInputStream input = InputSourceDataInputStream$.MODULE$.apply(is);
        ParseResult actual = p.parse(input, outputter);
        if (actual.isProcessingError()) {
            throw this.throwDiagnostics(actual.getDiagnostics());
        }
        return Tuple2$.MODULE$.apply((Object)actual, (Object)outputter.getResult());
    }

    public boolean runDataProcessorOnInputStream$default$3() {
        return false;
    }

    public Root getRoot(scala.collection.immutable.Seq<Node> contentElements, String elementFormDefault, scala.collection.immutable.Seq<Node> includeImports, scala.collection.immutable.Seq<Node> topLevels) {
        Elem testSchema = SchemaUtils$.MODULE$.dfdlTestSchema(includeImports, topLevels, contentElements, SchemaUtils$.MODULE$.dfdlTestSchema$default$4(), SchemaUtils$.MODULE$.dfdlTestSchema$default$5(), SchemaUtils$.MODULE$.dfdlTestSchema$default$6(), SchemaUtils$.MODULE$.dfdlTestSchema$default$7(), elementFormDefault, SchemaUtils$.MODULE$.dfdlTestSchema$default$9(), SchemaUtils$.MODULE$.dfdlTestSchema$default$10());
        SchemaSet sset = SchemaSet$.MODULE$.apply((Node)testSchema, SchemaSet$.MODULE$.apply$default$2(), SchemaSet$.MODULE$.apply$default$3(), SchemaSet$.MODULE$.apply$default$4(), SchemaSet$.MODULE$.apply$default$5());
        return sset.root();
    }

    public String getRoot$default$2() {
        return "unqualified";
    }

    public scala.collection.immutable.Seq<Node> getRoot$default$3() {
        return defaultIncludeImports;
    }

    public scala.collection.immutable.Seq<Node> getRoot$default$4() {
        return defaultTopLevels;
    }

    private Try<Tuple2<org.apache.daffodil.api.ProcessorFactory, org.apache.daffodil.api.DataProcessor>> compileAndSave(Compiler compiler, URISchemaSource schemaSource, WritableByteChannel output) {
        return Try$.MODULE$.apply(() -> TestUtils$.compileAndSave$$anonfun$1(compiler, schemaSource, output));
    }

    private static final Tuple2 compileAndSave$$anonfun$1(Compiler compiler$1, URISchemaSource schemaSource$1, WritableByteChannel output$1) {
        org.apache.daffodil.api.ProcessorFactory pf = compiler$1.compileSource((DaffodilSchemaSource)schemaSource$1, (Option)compiler$1.compileSource$default$2(), (Option)compiler$1.compileSource$default$3());
        if (((ProcessorFactory)pf).isError()) {
            throw MODULE$.throwDiagnostics(((ProcessorFactory)pf).getDiagnostics());
        }
        org.apache.daffodil.api.DataProcessor dp = ((ProcessorFactory)pf).onPath("/");
        dp.save(output$1);
        if (dp.isError()) {
            LinkedList<Diagnostic> tmp = new LinkedList<Diagnostic>(dp.getDiagnostics());
            tmp.addAll(((ProcessorFactory)pf).getDiagnostics());
            throw MODULE$.throwDiagnostics(tmp);
        }
        return Tuple2$.MODULE$.apply((Object)pf, (Object)dp);
    }
}

